///////////////////////////////////////////////////////////////////////////////////////////////////
// Company: Microsemi SoC Products Group
//
// File: eSRAM_eNVM_access_tb.v
// File history:
//      1.0: October 5, 2016: Written
//
// Description: Testbench for IGL2_esram_eNVM_RW_Fabric design
//
// <Description here>
//
// Targeted device: <Family::IGLOO2> <Die::M2GL090TS> <Package::484 FBGA>
// Author: Tim McCarthy
//
/////////////////////////////////////////////////////////////////////////////////////////////////// 

`timescale 1ns/100ps

module eSRAM_eNVM_access_tb;

parameter SYSCLK_PERIOD = 10;// 100MHZ

reg SYSCLK;
reg NSYSRESET;
wire   [7:0] RD_net;

initial
begin
    SYSCLK = 1'b0;
    NSYSRESET = 1'b0;
end

//////////////////////////////////////////////////////////////////////
// Reset Pulse
//////////////////////////////////////////////////////////////////////
initial
begin
    #(SYSCLK_PERIOD * 100 )
        NSYSRESET = 1'b1;
end


//////////////////////////////////////////////////////////////////////
// Clock Driver
//////////////////////////////////////////////////////////////////////
always @(SYSCLK)
    #(SYSCLK_PERIOD / 2.0) SYSCLK <= !SYSCLK;


//////////////////////////////////////////////////////////////////////
// Instantiate Unit Under Test:  eSRAM_eNVM_access
//////////////////////////////////////////////////////////////////////
eSRAM_eNVM_access eSRAM_eNVM_access_0 (
    // Inputs
    .DEVRST_N( NSYSRESET ),
    .start_envm( TestBench_pulsegenerator_0_start_envm ),
    .start_esram( TestBench_pulsegenerator_0_start_esram ),
    // Outputs
    .RD( RD_net )
);

//--------TestBench_pulsegenerator
TestBench_pulsegenerator TestBench_pulsegenerator_0(
        // Outputs
        .start_esram ( TestBench_pulsegenerator_0_start_esram ),
        .start_envm  ( TestBench_pulsegenerator_0_start_envm ) 
        );

endmodule

