quietly set ACTELLIBNAME IGLOO2
quietly set PROJECT_DIR "C:/Users/borgaa/Desktop/Microchip_training/Lab_files/IGL2_eSRAM_eNVM_lab/IGL2_eSRAM_eNVM_RW_Fabric"
source "${PROJECT_DIR}/simulation/bfmtovec_compile.tcl";

if {[file exists presynth/_info]} {
   echo "INFO: Simulation library presynth already exists"
} else {
   file delete -force presynth 
   vlib presynth
}
vmap presynth presynth
vmap IGLOO2 "C:/Microsemi/Libero_SoC_v12.2/Designer/lib/modelsimpro/precompiled/vlog/smartfusion2"
vmap SmartFusion2 "C:/Microsemi/Libero_SoC_v12.2/Designer/lib/modelsimpro/precompiled/vlog/smartfusion2"
vmap COREAHBLITE_LIB "../component/Actel/DirectCore/CoreAHBLite/5.2.100/mti/user_vlog/COREAHBLITE_LIB"
vcom -work COREAHBLITE_LIB -force_refresh
vlog -work COREAHBLITE_LIB -force_refresh

vlog -sv -work presynth "${PROJECT_DIR}/hdl/AHB_IF.v"
vlog -sv -work presynth "${PROJECT_DIR}/component/work/TPSRAM_C0/TPSRAM_C0_0/TPSRAM_C0_TPSRAM_C0_0_TPSRAM.v"
vlog -sv -work presynth "${PROJECT_DIR}/component/work/TPSRAM_C0/TPSRAM_C0.v"
vlog -sv -work presynth "${PROJECT_DIR}/hdl/eSRAM_eNVM_RW.v"
vlog -sv -work presynth "${PROJECT_DIR}/component/work/eSRAM_eNVM_access_sb/CCC_0/eSRAM_eNVM_access_sb_CCC_0_FCCC.v"
vlog -sv -work presynth "${PROJECT_DIR}/component/work/eSRAM_eNVM_access_sb/FABOSC_0/eSRAM_eNVM_access_sb_FABOSC_0_OSC.v"
vlog -sv -work presynth "${PROJECT_DIR}/component/work/eSRAM_eNVM_access_sb_HPMS/eSRAM_eNVM_access_sb_HPMS.v"
vlog -sv -work presynth "${PROJECT_DIR}/component/Actel/DirectCore/CoreResetP/7.1.100/rtl/vlog/core/coreresetp_pcie_hotreset.v"
vlog -sv -work presynth "${PROJECT_DIR}/component/Actel/DirectCore/CoreResetP/7.1.100/rtl/vlog/core/coreresetp.v"
vlog -sv -work COREAHBLITE_LIB "${PROJECT_DIR}/component/Actel/DirectCore/CoreAHBLite/5.2.100/rtl/vlog/core/coreahblite_slavearbiter.v"
vlog -sv -work COREAHBLITE_LIB "${PROJECT_DIR}/component/Actel/DirectCore/CoreAHBLite/5.2.100/rtl/vlog/core/coreahblite_slavestage.v"
vlog -sv -work COREAHBLITE_LIB "${PROJECT_DIR}/component/Actel/DirectCore/CoreAHBLite/5.2.100/rtl/vlog/core/coreahblite_defaultslavesm.v"
vlog -sv -work COREAHBLITE_LIB "${PROJECT_DIR}/component/Actel/DirectCore/CoreAHBLite/5.2.100/rtl/vlog/core/coreahblite_addrdec.v"
vlog -sv -work COREAHBLITE_LIB "${PROJECT_DIR}/component/Actel/DirectCore/CoreAHBLite/5.2.100/rtl/vlog/core/coreahblite_masterstage.v"
vlog -sv -work COREAHBLITE_LIB "${PROJECT_DIR}/component/Actel/DirectCore/CoreAHBLite/5.2.100/rtl/vlog/core/coreahblite_matrix4x16.v"
vlog -sv -work COREAHBLITE_LIB "${PROJECT_DIR}/component/Actel/DirectCore/CoreAHBLite/5.2.100/rtl/vlog/core/coreahblite.v"
vlog -sv -work presynth "${PROJECT_DIR}/component/work/eSRAM_eNVM_access_sb/eSRAM_eNVM_access_sb.v"
vlog -sv -work presynth "${PROJECT_DIR}/component/work/eSRAM_eNVM_access/eSRAM_eNVM_access.v"
vlog "+incdir+${PROJECT_DIR}/stimulus" -sv -work presynth "${PROJECT_DIR}/stimulus/TestBench_pulsegenerator.v"
vlog "+incdir+${PROJECT_DIR}/stimulus" -sv -work presynth "${PROJECT_DIR}/stimulus/eSRAM_eNVM_access_tb.v"

vsim -L IGLOO2 -L presynth -L COREAHBLITE_LIB  -t 1fs presynth.eSRAM_eNVM_access_tb
do "C:/Users/borgaa/Desktop/Microchip_training/Lab_files/IGL2_eSRAM_eNVM_lab/Source_files/wave.do"
run 40us
