//////////////////////////////////////////////////////////////////////
// Created by SmartDesign Mon Feb 17 11:43:20 2020
// Version: v12.2 12.700.0.22
//////////////////////////////////////////////////////////////////////

`timescale 1ns / 100ps

// eSRAM_eNVM_access
module eSRAM_eNVM_access(
    // Inputs
    DEVRST_N,
    start_envm,
    start_esram,
    // Outputs
    RD
);

//--------------------------------------------------------------------
// Input
//--------------------------------------------------------------------
input        DEVRST_N;
input        start_envm;
input        start_esram;
//--------------------------------------------------------------------
// Output
//--------------------------------------------------------------------
output [7:0] RD;
//--------------------------------------------------------------------
// Nets
//--------------------------------------------------------------------
wire          AHB_IF_0_AHB_BUSY;
wire   [31:0] AHB_IF_0_BIF_1_HADDR;
wire   [2:0]  AHB_IF_0_BIF_1_HBURST;
wire   [3:0]  AHB_IF_0_BIF_1_HPROT;
wire   [31:0] AHB_IF_0_BIF_1_HRDATA;
wire          AHB_IF_0_BIF_1_HREADY;
wire   [1:0]  AHB_IF_0_BIF_1_HRESP;
wire   [2:0]  AHB_IF_0_BIF_1_HSIZE;
wire   [1:0]  AHB_IF_0_BIF_1_HTRANS;
wire   [31:0] AHB_IF_0_BIF_1_HWDATA;
wire          AHB_IF_0_BIF_1_HWRITE;
wire   [31:0] AHB_IF_0_DATAOUT;
wire          AHB_IF_0_VALID;
wire          DEVRST_N;
wire          eSRAM_eNVM_access_sb_0_FIC_0_CLK;
wire          eSRAM_eNVM_access_sb_0_HPMS_READY;
wire   [31:0] eSRAM_eNVM_RW_0_ADDR;
wire   [31:0] eSRAM_eNVM_RW_0_DATAOUT;
wire   [4:0]  eSRAM_eNVM_RW_0_ram_waddr;
wire   [31:0] eSRAM_eNVM_RW_0_ram_wdata;
wire          eSRAM_eNVM_RW_0_ram_wen;
wire          eSRAM_eNVM_RW_0_READ;
wire          eSRAM_eNVM_RW_0_WRITE;
wire   [7:0]  RD_net_0;
wire          start_envm;
wire          start_esram;
wire   [7:0]  RD_net_1;
wire   [31:8] RD_slice_0;
wire   [31:0] RD_net_2;
//--------------------------------------------------------------------
// TiedOff Nets
//--------------------------------------------------------------------
wire   [2:0]  HSIZE_IN_const_net_0;
wire          VCC_net;
wire   [4:0]  RADDR_const_net_0;
wire          GND_net;
//--------------------------------------------------------------------
// Constant assignments
//--------------------------------------------------------------------
assign HSIZE_IN_const_net_0 = 3'h2;
assign VCC_net              = 1'b1;
assign RADDR_const_net_0    = 5'h00;
assign GND_net              = 1'b0;
//--------------------------------------------------------------------
// Top level output port assignments
//--------------------------------------------------------------------
assign RD_net_1 = RD_net_0;
assign RD[7:0]  = RD_net_1;
//--------------------------------------------------------------------
// Slices assignments
//--------------------------------------------------------------------
assign RD_net_0   = RD_net_2[7:0];
assign RD_slice_0 = RD_net_2[31:8];
//--------------------------------------------------------------------
// Component instances
//--------------------------------------------------------------------
//--------AHB_IF
AHB_IF #( 
        .Data_size   ( 32 ),
        .Idle_1      ( 0 ),
        .Read_FIC_0  ( 4 ),
        .Read_FIC_1  ( 5 ),
        .Read_FIC_2  ( 6 ),
        .Write_FIC_0 ( 1 ),
        .Write_FIC_1 ( 2 ),
        .Write_FIC_2 ( 3 ) )
AHB_IF_0(
        // Inputs
        .HCLK     ( eSRAM_eNVM_access_sb_0_FIC_0_CLK ),
        .HRESETn  ( eSRAM_eNVM_access_sb_0_HPMS_READY ),
        .READ     ( eSRAM_eNVM_RW_0_READ ),
        .WRITE    ( eSRAM_eNVM_RW_0_WRITE ),
        .ADDR     ( eSRAM_eNVM_RW_0_ADDR ),
        .DATAIN   ( eSRAM_eNVM_RW_0_DATAOUT ),
        .HSIZE_IN ( HSIZE_IN_const_net_0 ),
        .HRDATA   ( AHB_IF_0_BIF_1_HRDATA ),
        .HREADY   ( AHB_IF_0_BIF_1_HREADY ),
        .HRESP    ( AHB_IF_0_BIF_1_HRESP ),
        // Outputs
        .DATAOUT  ( AHB_IF_0_DATAOUT ),
        .HADDR    ( AHB_IF_0_BIF_1_HADDR ),
        .HTRANS   ( AHB_IF_0_BIF_1_HTRANS ),
        .HWRITE   ( AHB_IF_0_BIF_1_HWRITE ),
        .HSIZE    ( AHB_IF_0_BIF_1_HSIZE ),
        .HBURST   ( AHB_IF_0_BIF_1_HBURST ),
        .HPROT    ( AHB_IF_0_BIF_1_HPROT ),
        .HWDATA   ( AHB_IF_0_BIF_1_HWDATA ),
        .RESP_err (  ),
        .AHB_BUSY ( AHB_IF_0_AHB_BUSY ),
        .VALID    ( AHB_IF_0_VALID ) 
        );

//--------eSRAM_eNVM_access_sb
eSRAM_eNVM_access_sb eSRAM_eNVM_access_sb_0(
        // Inputs
        .FAB_RESET_N                         ( VCC_net ),
        .HPMS_FIC_0_USER_MASTER_HADDR_M0     ( AHB_IF_0_BIF_1_HADDR ),
        .HPMS_FIC_0_USER_MASTER_HTRANS_M0    ( AHB_IF_0_BIF_1_HTRANS ),
        .HPMS_FIC_0_USER_MASTER_HWRITE_M0    ( AHB_IF_0_BIF_1_HWRITE ),
        .HPMS_FIC_0_USER_MASTER_HSIZE_M0     ( AHB_IF_0_BIF_1_HSIZE ),
        .HPMS_FIC_0_USER_MASTER_HBURST_M0    ( AHB_IF_0_BIF_1_HBURST ),
        .HPMS_FIC_0_USER_MASTER_HPROT_M0     ( AHB_IF_0_BIF_1_HPROT ),
        .HPMS_FIC_0_USER_MASTER_HWDATA_M0    ( AHB_IF_0_BIF_1_HWDATA ),
        .HPMS_FIC_0_USER_MASTER_HMASTLOCK_M0 ( GND_net ), // tied to 1'b0 from definition
        .DEVRST_N                            ( DEVRST_N ),
        // Outputs
        .POWER_ON_RESET_N                    (  ),
        .INIT_DONE                           (  ),
        .FIC_0_CLK                           ( eSRAM_eNVM_access_sb_0_FIC_0_CLK ),
        .FIC_0_LOCK                          (  ),
        .HPMS_READY                          ( eSRAM_eNVM_access_sb_0_HPMS_READY ),
        .HPMS_FIC_0_USER_MASTER_HRDATA_M0    ( AHB_IF_0_BIF_1_HRDATA ),
        .HPMS_FIC_0_USER_MASTER_HREADY_M0    ( AHB_IF_0_BIF_1_HREADY ),
        .HPMS_FIC_0_USER_MASTER_HRESP_M0     ( AHB_IF_0_BIF_1_HRESP ),
        .COMM_BLK_INT                        (  ),
        .HPMS_INT_M2F                        (  ) 
        );

//--------eSRAM_eNVM_RW
eSRAM_eNVM_RW eSRAM_eNVM_RW_0(
        // Inputs
        .CLK         ( eSRAM_eNVM_access_sb_0_FIC_0_CLK ),
        .RESETn      ( eSRAM_eNVM_access_sb_0_HPMS_READY ),
        .start_envm  ( start_envm ),
        .start_esram ( start_esram ),
        .valid       ( AHB_IF_0_VALID ),
        .DATAIN      ( AHB_IF_0_DATAOUT ),
        .busy        ( AHB_IF_0_AHB_BUSY ),
        // Outputs
        .READ        ( eSRAM_eNVM_RW_0_READ ),
        .WRITE       ( eSRAM_eNVM_RW_0_WRITE ),
        .ADDR        ( eSRAM_eNVM_RW_0_ADDR ),
        .DATAOUT     ( eSRAM_eNVM_RW_0_DATAOUT ),
        .ram_wen     ( eSRAM_eNVM_RW_0_ram_wen ),
        .ram_waddr   ( eSRAM_eNVM_RW_0_ram_waddr ),
        .ram_wdata   ( eSRAM_eNVM_RW_0_ram_wdata ) 
        );

//--------TPSRAM_C0
TPSRAM_C0 TPSRAM_C0_0(
        // Inputs
        .WEN   ( eSRAM_eNVM_RW_0_ram_wen ),
        .CLK   ( eSRAM_eNVM_access_sb_0_FIC_0_CLK ),
        .WD    ( eSRAM_eNVM_RW_0_ram_wdata ),
        .WADDR ( eSRAM_eNVM_RW_0_ram_waddr ),
        .RADDR ( RADDR_const_net_0 ),
        .REN   ( GND_net ),
        // Outputs
        .RD    ( RD_net_2 ) 
        );


endmodule
