// ********************************************************************/
// Actel Corporation Proprietary and Confidential
// Copyright 2010 Actel Corporation.  All rights reserved.
//
// ANY USE OR REDISTRIBUTION IN PART OR IN WHOLE MUST BE HANDLED IN
// ACCORDANCE WITH THE ACTEL LICENSE AGREEMENT AND MUST BE APPROVED
// IN ADVANCE IN WRITING.
//
// Description:	CoreAHBLite - user testbench
//
//
// SVN Revision Information:
// SVN $Revision: 22340 $
// SVN $Date: 2014-04-11 17:29:35 +0100 (Fri, 11 Apr 2014) $
//
//
// Notes:
// 1. best viewed with tabstops set to "4" (tabs used throughout file)
//
// *********************************************************************/

`timescale 1ns/1ps

module testbench();

// location of this can be overridden at compile time (+incdir switch)
`include "coreparameters.v"

parameter SYSCLK_PERIOD = 10; // 100MHz

// the locations and names of these can be overridden at run time
parameter MASTER0_VECTFILE	= "coreahblite_usertb_ahb_master0.vec";
parameter MASTER1_VECTFILE	= "coreahblite_usertb_ahb_master1.vec";
parameter MASTER2_VECTFILE	= "coreahblite_usertb_ahb_master2.vec";
parameter MASTER3_VECTFILE	= "coreahblite_usertb_ahb_master3.vec";

// propagation delay in ns
parameter TPD			= 3;

reg					stopsim=0;

reg					SYSCLK;
reg					SYSRSTN;
// using HCLK & HRESETN from master 0 to connect to CoreAHBLite
wire				HCLK;
wire				HRESETN;

// control remap signal from master 0 BFM
wire				REMAP_M0;

// GPIO for 2 master BFM's
wire	[31:0]		GP_OUT_M0;
wire	[31:0]		GP_OUT_M1;
// GP_IN shared
wire	[31:0]		GP_IN;

// signals for testbench request/acknowledgement between masters
wire				M0_REQ;
wire				M0_ACK;
wire				M1_REQ;
wire				M1_ACK;


wire				HREADY_M0;
wire	[1:0]		HRESP_M0;
wire	[31:0]		HRDATA_M0;
wire	[1:0]		HTRANS_M0;
wire	[2:0]		HSIZE_M0;
wire				HWRITE_M0;
wire				HMASTLOCK_M0;
wire	[31:0]		HADDR_M0;
wire	[31:0]		HWDATA_M0;
wire	[2:0]		HBURST_M0;
wire	[3:0]		HPROT_M0;

wire				HREADY_M1;
wire	[1:0]		HRESP_M1;
wire	[31:0]		HRDATA_M1;
wire	[1:0]		HTRANS_M1;
wire	[2:0]		HSIZE_M1;
wire				HWRITE_M1;
wire				HMASTLOCK_M1;
wire	[31:0]		HADDR_M1;
wire	[31:0]		HWDATA_M1;
wire	[2:0]		HBURST_M1;
wire	[3:0]		HPROT_M1;

wire				HREADY_M2;
wire	[1:0]		HRESP_M2;
wire	[31:0]		HRDATA_M2;
wire	[1:0]		HTRANS_M2;
wire	[2:0]		HSIZE_M2;
wire				HWRITE_M2;
wire				HMASTLOCK_M2;
wire	[31:0]		HADDR_M2;
wire	[31:0]		HWDATA_M2;
wire	[2:0]		HBURST_M2;
wire	[3:0]		HPROT_M2;

wire				HREADY_M3;
wire	[1:0]		HRESP_M3;
wire	[31:0]		HRDATA_M3;
wire	[1:0]		HTRANS_M3;
wire	[2:0]		HSIZE_M3;
wire				HWRITE_M3;
wire				HMASTLOCK_M3;
wire	[31:0]		HADDR_M3;
wire	[31:0]		HWDATA_M3;
wire	[2:0]		HBURST_M3;
wire	[3:0]		HPROT_M3;

wire				HWRITE_S0;
wire	[2:0]		HSIZE_S0;
wire	[1:0]		HTRANS_S0;
wire	[31:0]		HWDATA_S0;
wire				HREADYIN_S0;
wire				HSEL_S0;
wire	[31:0]		HADDR_S0;
wire	[31:0]		HRDATA_S0;
wire	[1:0]		HRESP_S0;
wire				HREADY_S0;
wire				HMASTLOCK_S0;
wire	[2:0]		HBURST_S0;
wire	[3:0]		HPROT_S0;

wire				HWRITE_S1;
wire	[2:0]		HSIZE_S1;
wire	[1:0]		HTRANS_S1;
wire	[31:0]		HWDATA_S1;
wire				HREADYIN_S1;
wire				HSEL_S1;
wire	[31:0]		HADDR_S1;
wire	[31:0]		HRDATA_S1;
wire	[1:0]		HRESP_S1;
wire				HREADY_S1;
wire				HMASTLOCK_S1;
wire	[2:0]		HBURST_S1;
wire	[3:0]		HPROT_S1;

wire				HWRITE_S2;
wire	[2:0]		HSIZE_S2;
wire	[1:0]		HTRANS_S2;
wire	[31:0]		HWDATA_S2;
wire				HREADYIN_S2;
wire				HSEL_S2;
wire	[31:0]		HADDR_S2;
wire	[31:0]		HRDATA_S2;
wire	[1:0]		HRESP_S2;
wire				HREADY_S2;
wire				HMASTLOCK_S2;
wire	[2:0]		HBURST_S2;
wire	[3:0]		HPROT_S2;

wire				HWRITE_S3;
wire	[2:0]		HSIZE_S3;
wire	[1:0]		HTRANS_S3;
wire	[31:0]		HWDATA_S3;
wire				HREADYIN_S3;
wire				HSEL_S3;
wire	[31:0]		HADDR_S3;
wire	[31:0]		HRDATA_S3;
wire	[1:0]		HRESP_S3;
wire				HREADY_S3;
wire				HMASTLOCK_S3;
wire	[2:0]		HBURST_S3;
wire	[3:0]		HPROT_S3;

wire				HWRITE_S4;
wire	[2:0]		HSIZE_S4;
wire	[1:0]		HTRANS_S4;
wire	[31:0]		HWDATA_S4;
wire				HREADYIN_S4;
wire				HSEL_S4;
wire	[31:0]		HADDR_S4;
wire	[31:0]		HRDATA_S4;
wire	[1:0]		HRESP_S4;
wire				HREADY_S4;
wire				HMASTLOCK_S4;
wire	[2:0]		HBURST_S4;
wire	[3:0]		HPROT_S4;

wire				HWRITE_S5;
wire	[2:0]		HSIZE_S5;
wire	[1:0]		HTRANS_S5;
wire	[31:0]		HWDATA_S5;
wire				HREADYIN_S5;
wire				HSEL_S5;
wire	[31:0]		HADDR_S5;
wire	[31:0]		HRDATA_S5;
wire	[1:0]		HRESP_S5;
wire				HREADY_S5;
wire				HMASTLOCK_S5;
wire	[2:0]		HBURST_S5;
wire	[3:0]		HPROT_S5;

wire				HWRITE_S6;
wire	[2:0]		HSIZE_S6;
wire	[1:0]		HTRANS_S6;
wire	[31:0]		HWDATA_S6;
wire				HREADYIN_S6;
wire				HSEL_S6;
wire	[31:0]		HADDR_S6;
wire	[31:0]		HRDATA_S6;
wire	[1:0]		HRESP_S6;
wire				HREADY_S6;
wire				HMASTLOCK_S6;
wire	[2:0]		HBURST_S6;
wire	[3:0]		HPROT_S6;

wire				HWRITE_S7;
wire	[2:0]		HSIZE_S7;
wire	[1:0]		HTRANS_S7;
wire	[31:0]		HWDATA_S7;
wire				HREADYIN_S7;
wire				HSEL_S7;
wire	[31:0]		HADDR_S7;
wire	[31:0]		HRDATA_S7;
wire	[1:0]		HRESP_S7;
wire				HREADY_S7;
wire				HMASTLOCK_S7;
wire	[2:0]		HBURST_S7;
wire	[3:0]		HPROT_S7;

wire				HWRITE_S8;
wire	[2:0]		HSIZE_S8;
wire	[1:0]		HTRANS_S8;
wire	[31:0]		HWDATA_S8;
wire				HREADYIN_S8;
wire				HSEL_S8;
wire	[31:0]		HADDR_S8;
wire	[31:0]		HRDATA_S8;
wire	[1:0]		HRESP_S8;
wire				HREADY_S8;
wire				HMASTLOCK_S8;
wire	[2:0]		HBURST_S8;
wire	[3:0]		HPROT_S8;

wire				HWRITE_S9;
wire	[2:0]		HSIZE_S9;
wire	[1:0]		HTRANS_S9;
wire	[31:0]		HWDATA_S9;
wire				HREADYIN_S9;
wire				HSEL_S9;
wire	[31:0]		HADDR_S9;
wire	[31:0]		HRDATA_S9;
wire	[1:0]		HRESP_S9;
wire				HREADY_S9;
wire				HMASTLOCK_S9;
wire	[2:0]		HBURST_S9;
wire	[3:0]		HPROT_S9;

wire				HWRITE_S10;
wire	[2:0]		HSIZE_S10;
wire	[1:0]		HTRANS_S10;
wire	[31:0]		HWDATA_S10;
wire				HREADYIN_S10;
wire				HSEL_S10;
wire	[31:0]		HADDR_S10;
wire	[31:0]		HRDATA_S10;
wire	[1:0]		HRESP_S10;
wire				HREADY_S10;
wire				HMASTLOCK_S10;
wire	[2:0]		HBURST_S10;
wire	[3:0]		HPROT_S10;

wire				HWRITE_S11;
wire	[2:0]		HSIZE_S11;
wire	[1:0]		HTRANS_S11;
wire	[31:0]		HWDATA_S11;
wire				HREADYIN_S11;
wire				HSEL_S11;
wire	[31:0]		HADDR_S11;
wire	[31:0]		HRDATA_S11;
wire	[1:0]		HRESP_S11;
wire				HREADY_S11;
wire				HMASTLOCK_S11;
wire	[2:0]		HBURST_S11;
wire	[3:0]		HPROT_S11;

wire				HWRITE_S12;
wire	[2:0]		HSIZE_S12;
wire	[1:0]		HTRANS_S12;
wire	[31:0]		HWDATA_S12;
wire				HREADYIN_S12;
wire				HSEL_S12;
wire	[31:0]		HADDR_S12;
wire	[31:0]		HRDATA_S12;
wire	[1:0]		HRESP_S12;
wire				HREADY_S12;
wire				HMASTLOCK_S12;
wire	[2:0]		HBURST_S12;
wire	[3:0]		HPROT_S12;

wire				HWRITE_S13;
wire	[2:0]		HSIZE_S13;
wire	[1:0]		HTRANS_S13;
wire	[31:0]		HWDATA_S13;
wire				HREADYIN_S13;
wire				HSEL_S13;
wire	[31:0]		HADDR_S13;
wire	[31:0]		HRDATA_S13;
wire	[1:0]		HRESP_S13;
wire				HREADY_S13;
wire				HMASTLOCK_S13;
wire	[2:0]		HBURST_S13;
wire	[3:0]		HPROT_S13;

wire				HWRITE_S14;
wire	[2:0]		HSIZE_S14;
wire	[1:0]		HTRANS_S14;
wire	[31:0]		HWDATA_S14;
wire				HREADYIN_S14;
wire				HSEL_S14;
wire	[31:0]		HADDR_S14;
wire	[31:0]		HRDATA_S14;
wire	[1:0]		HRESP_S14;
wire				HREADY_S14;
wire				HMASTLOCK_S14;
wire	[2:0]		HBURST_S14;
wire	[3:0]		HPROT_S14;

wire				HWRITE_S15;
wire	[2:0]		HSIZE_S15;
wire	[1:0]		HTRANS_S15;
wire	[31:0]		HWDATA_S15;
wire				HREADYIN_S15;
wire				HSEL_S15;
wire	[31:0]		HADDR_S15;
wire	[31:0]		HRDATA_S15;
wire	[1:0]		HRESP_S15;
wire				HREADY_S15;
wire				HMASTLOCK_S15;
wire	[2:0]		HBURST_S15;
wire	[3:0]		HPROT_S15;

wire				HWRITE_S16;
wire	[2:0]		HSIZE_S16;
wire	[1:0]		HTRANS_S16;
wire	[31:0]		HWDATA_S16;
wire				HREADYIN_S16;
wire				HSEL_S16;
wire	[31:0]		HADDR_S16;
wire	[31:0]		HRDATA_S16;
wire	[1:0]		HRESP_S16;
wire				HREADY_S16;
wire				HMASTLOCK_S16;
wire	[2:0]		HBURST_S16;
wire	[3:0]		HPROT_S16;

wire				FINISHED_master0;
wire				FINISHED_master1;
wire				FINISHED_master2;
wire				FINISHED_master3;

reg                 s0_write;
reg                 s1_write;
reg                 s2_write;
reg                 s3_write;
reg                 s4_write;
reg                 s5_write;
reg                 s6_write;
reg                 s7_write;
reg                 s8_write;
reg                 s9_write;
reg                 s10_write;
reg                 s11_write;
reg                 s12_write;
reg                 s13_write;
reg                 s14_write;
reg                 s15_write;
reg                 s16_write;

initial
begin
    SYSCLK = 1'b0;
    SYSRSTN = 1'b0;

	// Release system reset
    #(SYSCLK_PERIOD * 4)
        SYSRSTN = 1'b1;

	// wait until all BFM's are finished
	while (
	       !(
	            (FINISHED_master0 === 1'b1)
	         && (FINISHED_master1 === 1'b1)
	         && (FINISHED_master2 === 1'b1)
	         && (FINISHED_master3 === 1'b1)
	        )
	      )
	begin
		@ (posedge SYSCLK); #TPD;
	end
	stopsim=1;
	#1;
	$stop;
end

// tie-off unused inputs to DUT
assign HBURST_M0	= 3'b0;
assign HBURST_M1	= 3'b0;
assign HBURST_M2	= 3'b0;
assign HBURST_M3	= 3'b0;
assign HPROT_M0		= 4'b0;
assign HPROT_M1		= 4'b0;
assign HPROT_M2		= 4'b0;
assign HPROT_M3		= 4'b0;
assign HRESP_S0[1]	= 1'b0;
assign HRESP_S1[1]	= 1'b0;
assign HRESP_S2[1]	= 1'b0;
assign HRESP_S3[1]	= 1'b0;
assign HRESP_S4[1]	= 1'b0;
assign HRESP_S5[1]	= 1'b0;
assign HRESP_S6[1]	= 1'b0;
assign HRESP_S7[1]	= 1'b0;
assign HRESP_S8[1]	= 1'b0;
assign HRESP_S9[1]	= 1'b0;
assign HRESP_S10[1]	= 1'b0;
assign HRESP_S11[1]	= 1'b0;
assign HRESP_S12[1]	= 1'b0;
assign HRESP_S13[1]	= 1'b0;
assign HRESP_S14[1]	= 1'b0;
assign HRESP_S15[1]	= 1'b0;
assign HRESP_S16[1]	= 1'b0;

// SYSCLK signal
always @(SYSCLK)
    #(SYSCLK_PERIOD / 2)
    SYSCLK <= !SYSCLK;

// Instantiate module to test
CoreAHBLite #(
	.FAMILY (FAMILY),
	.MEMSPACE (MEMSPACE),
    .HADDR_SHG_CFG (HADDR_SHG_CFG),
	.SC_0 (SC_0),
	.SC_1 (SC_1),
	.SC_2 (SC_2),
	.SC_3 (SC_3),
	.SC_4 (SC_4),
	.SC_5 (SC_5),
	.SC_6 (SC_6),
	.SC_7 (SC_7),
	.SC_8 (SC_8),
	.SC_9 (SC_9),
	.SC_10(SC_10),
	.SC_11(SC_11),
	.SC_12(SC_12),
	.SC_13(SC_13),
	.SC_14(SC_14),
	.SC_15(SC_15),
	.M0_AHBSLOT0ENABLE (M0_AHBSLOT0ENABLE),
	.M0_AHBSLOT1ENABLE (M0_AHBSLOT1ENABLE),
	.M0_AHBSLOT2ENABLE (M0_AHBSLOT2ENABLE),
	.M0_AHBSLOT3ENABLE (M0_AHBSLOT3ENABLE),
	.M0_AHBSLOT4ENABLE (M0_AHBSLOT4ENABLE),
	.M0_AHBSLOT5ENABLE (M0_AHBSLOT5ENABLE),
	.M0_AHBSLOT6ENABLE (M0_AHBSLOT6ENABLE),
	.M0_AHBSLOT7ENABLE (M0_AHBSLOT7ENABLE),
	.M0_AHBSLOT8ENABLE (M0_AHBSLOT8ENABLE),
	.M0_AHBSLOT9ENABLE (M0_AHBSLOT9ENABLE),
	.M0_AHBSLOT10ENABLE(M0_AHBSLOT10ENABLE),
	.M0_AHBSLOT11ENABLE(M0_AHBSLOT11ENABLE),
	.M0_AHBSLOT12ENABLE(M0_AHBSLOT12ENABLE),
	.M0_AHBSLOT13ENABLE(M0_AHBSLOT13ENABLE),
	.M0_AHBSLOT14ENABLE(M0_AHBSLOT14ENABLE),
	.M0_AHBSLOT15ENABLE(M0_AHBSLOT15ENABLE),
	.M0_AHBSLOT16ENABLE(M0_AHBSLOT16ENABLE),
	.M1_AHBSLOT0ENABLE (M1_AHBSLOT0ENABLE),
	.M1_AHBSLOT1ENABLE (M1_AHBSLOT1ENABLE),
	.M1_AHBSLOT2ENABLE (M1_AHBSLOT2ENABLE),
	.M1_AHBSLOT3ENABLE (M1_AHBSLOT3ENABLE),
	.M1_AHBSLOT4ENABLE (M1_AHBSLOT4ENABLE),
	.M1_AHBSLOT5ENABLE (M1_AHBSLOT5ENABLE),
	.M1_AHBSLOT6ENABLE (M1_AHBSLOT6ENABLE),
	.M1_AHBSLOT7ENABLE (M1_AHBSLOT7ENABLE),
	.M1_AHBSLOT8ENABLE (M1_AHBSLOT8ENABLE),
	.M1_AHBSLOT9ENABLE (M1_AHBSLOT9ENABLE),
	.M1_AHBSLOT10ENABLE(M1_AHBSLOT10ENABLE),
	.M1_AHBSLOT11ENABLE(M1_AHBSLOT11ENABLE),
	.M1_AHBSLOT12ENABLE(M1_AHBSLOT12ENABLE),
	.M1_AHBSLOT13ENABLE(M1_AHBSLOT13ENABLE),
	.M1_AHBSLOT14ENABLE(M1_AHBSLOT14ENABLE),
	.M1_AHBSLOT15ENABLE(M1_AHBSLOT15ENABLE),
	.M1_AHBSLOT16ENABLE(M1_AHBSLOT16ENABLE),
	.M2_AHBSLOT0ENABLE (M2_AHBSLOT0ENABLE),
	.M2_AHBSLOT1ENABLE (M2_AHBSLOT1ENABLE),
	.M2_AHBSLOT2ENABLE (M2_AHBSLOT2ENABLE),
	.M2_AHBSLOT3ENABLE (M2_AHBSLOT3ENABLE),
	.M2_AHBSLOT4ENABLE (M2_AHBSLOT4ENABLE),
	.M2_AHBSLOT5ENABLE (M2_AHBSLOT5ENABLE),
	.M2_AHBSLOT6ENABLE (M2_AHBSLOT6ENABLE),
	.M2_AHBSLOT7ENABLE (M2_AHBSLOT7ENABLE),
	.M2_AHBSLOT8ENABLE (M2_AHBSLOT8ENABLE),
	.M2_AHBSLOT9ENABLE (M2_AHBSLOT9ENABLE),
	.M2_AHBSLOT10ENABLE(M2_AHBSLOT10ENABLE),
	.M2_AHBSLOT11ENABLE(M2_AHBSLOT11ENABLE),
	.M2_AHBSLOT12ENABLE(M2_AHBSLOT12ENABLE),
	.M2_AHBSLOT13ENABLE(M2_AHBSLOT13ENABLE),
	.M2_AHBSLOT14ENABLE(M2_AHBSLOT14ENABLE),
	.M2_AHBSLOT15ENABLE(M2_AHBSLOT15ENABLE),
	.M2_AHBSLOT16ENABLE(M2_AHBSLOT16ENABLE),
	.M3_AHBSLOT0ENABLE (M3_AHBSLOT0ENABLE),
	.M3_AHBSLOT1ENABLE (M3_AHBSLOT1ENABLE),
	.M3_AHBSLOT2ENABLE (M3_AHBSLOT2ENABLE),
	.M3_AHBSLOT3ENABLE (M3_AHBSLOT3ENABLE),
	.M3_AHBSLOT4ENABLE (M3_AHBSLOT4ENABLE),
	.M3_AHBSLOT5ENABLE (M3_AHBSLOT5ENABLE),
	.M3_AHBSLOT6ENABLE (M3_AHBSLOT6ENABLE),
	.M3_AHBSLOT7ENABLE (M3_AHBSLOT7ENABLE),
	.M3_AHBSLOT8ENABLE (M3_AHBSLOT8ENABLE),
	.M3_AHBSLOT9ENABLE (M3_AHBSLOT9ENABLE),
	.M3_AHBSLOT10ENABLE(M3_AHBSLOT10ENABLE),
	.M3_AHBSLOT11ENABLE(M3_AHBSLOT11ENABLE),
	.M3_AHBSLOT12ENABLE(M3_AHBSLOT12ENABLE),
	.M3_AHBSLOT13ENABLE(M3_AHBSLOT13ENABLE),
	.M3_AHBSLOT14ENABLE(M3_AHBSLOT14ENABLE),
	.M3_AHBSLOT15ENABLE(M3_AHBSLOT15ENABLE),
	.M3_AHBSLOT16ENABLE(M3_AHBSLOT16ENABLE)
) u_coreahblite (
	// ResetController interface
	// Inputs
	.HCLK(HCLK),
	.HRESETN(HRESETN),

	// controls master 0 memory aliasing (swaps slots 0 and 1)
	.REMAP_M0(REMAP_M0),

	// Mirrored master AHB-Lite interface to Master 0
	// Inputs
	.HADDR_M0(HADDR_M0),
	.HMASTLOCK_M0(HMASTLOCK_M0),
	.HSIZE_M0(HSIZE_M0),
	.HTRANS_M0(HTRANS_M0),
	.HWRITE_M0(HWRITE_M0),
	.HWDATA_M0(HWDATA_M0),
	.HBURST_M0(HBURST_M0),
	.HPROT_M0(HPROT_M0),
	// Outputs
	.HRESP_M0(HRESP_M0),
	.HRDATA_M0(HRDATA_M0),
	.HREADY_M0(HREADY_M0),

	// Mirrored master AHB-Lite interface to Master 1
	// Inputs
	.HADDR_M1(HADDR_M1),
	.HMASTLOCK_M1(HMASTLOCK_M1),
	.HSIZE_M1(HSIZE_M1),
	.HTRANS_M1(HTRANS_M1),
	.HWRITE_M1(HWRITE_M1),
	.HWDATA_M1(HWDATA_M1),
	.HBURST_M1(HBURST_M1),
	.HPROT_M1(HPROT_M1),

	// Outputs
	.HRESP_M1(HRESP_M1),
	.HRDATA_M1(HRDATA_M1),
	.HREADY_M1(HREADY_M1),

	// Mirrored master AHB-Lite interface to Master 2
	// Inputs
	.HADDR_M2(HADDR_M2),
	.HMASTLOCK_M2(HMASTLOCK_M2),
	.HSIZE_M2(HSIZE_M2),
	.HTRANS_M2(HTRANS_M2),
	.HWRITE_M2(HWRITE_M2),
	.HWDATA_M2(HWDATA_M2),
	.HBURST_M2(HBURST_M2),
	.HPROT_M2(HPROT_M2),

	// Outputs
	.HRESP_M2(HRESP_M2),
	.HRDATA_M2(HRDATA_M2),
	.HREADY_M2(HREADY_M2),

	// Mirrored master AHB-Lite interface to Master 3
	// Inputs
	.HADDR_M3(HADDR_M3),
	.HMASTLOCK_M3(HMASTLOCK_M3),
	.HSIZE_M3(HSIZE_M3),
	.HTRANS_M3(HTRANS_M3),
	.HWRITE_M3(HWRITE_M3),
	.HWDATA_M3(HWDATA_M3),
	.HBURST_M3(HBURST_M3),
	.HPROT_M3(HPROT_M3),

	// Outputs
	.HRESP_M3(HRESP_M3),
	.HRDATA_M3(HRDATA_M3),
	.HREADY_M3(HREADY_M3),

	// Mirrored slave AHB-Lite interface to Slave 0
	// Inputs
	.HRDATA_S0(HRDATA_S0),
	.HREADYOUT_S0(HREADY_S0),
	.HRESP_S0(HRESP_S0),
	// Outputs
	.HSEL_S0(HSEL_S0),
	.HADDR_S0(HADDR_S0),
	.HSIZE_S0(HSIZE_S0),
	.HTRANS_S0(HTRANS_S0),
	.HWRITE_S0(HWRITE_S0),
	.HWDATA_S0(HWDATA_S0),
	.HREADY_S0(HREADYIN_S0),
	.HMASTLOCK_S0(HMASTLOCK_S0),
	.HBURST_S0(HBURST_S0),
	.HPROT_S0(HPROT_S0),

	// Mirrored slave AHB-Lite interface to Slave 1
	// Inputs
	.HRDATA_S1(HRDATA_S1),
	.HREADYOUT_S1(HREADY_S1),
	.HRESP_S1(HRESP_S1),
	// Outputs
	.HSEL_S1(HSEL_S1),
	.HADDR_S1(HADDR_S1),
	.HSIZE_S1(HSIZE_S1),
	.HTRANS_S1(HTRANS_S1),
	.HWRITE_S1(HWRITE_S1),
	.HWDATA_S1(HWDATA_S1),
	.HREADY_S1(HREADYIN_S1),
	.HMASTLOCK_S1(HMASTLOCK_S1),
	.HBURST_S1(HBURST_S1),
	.HPROT_S1(HPROT_S1),

	// Mirrored slave AHB-Lite interface to Slave 2
	// Inputs
	.HRDATA_S2(HRDATA_S2),
	.HREADYOUT_S2(HREADY_S2),
	.HRESP_S2(HRESP_S2),
	// Outputs
	.HSEL_S2(HSEL_S2),
	.HADDR_S2(HADDR_S2),
	.HSIZE_S2(HSIZE_S2),
	.HTRANS_S2(HTRANS_S2),
	.HWRITE_S2(HWRITE_S2),
	.HWDATA_S2(HWDATA_S2),
	.HREADY_S2(HREADYIN_S2),
	.HMASTLOCK_S2(HMASTLOCK_S2),
	.HBURST_S2(HBURST_S2),
	.HPROT_S2(HPROT_S2),

	// Mirrored slave AHB-Lite interface to Slave 3
	// Inputs
	.HRDATA_S3(HRDATA_S3),
	.HREADYOUT_S3(HREADY_S3),
	.HRESP_S3(HRESP_S3),
	// Output
	.HSEL_S3(HSEL_S3),
	.HADDR_S3(HADDR_S3),
	.HSIZE_S3(HSIZE_S3),
	.HTRANS_S3(HTRANS_S3),
	.HWRITE_S3(HWRITE_S3),
	.HWDATA_S3(HWDATA_S3),
	.HREADY_S3(HREADYIN_S3),
	.HMASTLOCK_S3(HMASTLOCK_S3),
	.HBURST_S3(HBURST_S3),
	.HPROT_S3(HPROT_S3),

	// Mirrored slave AHB-Lite interface to Slave 4
	// Inputs
	.HRDATA_S4(HRDATA_S4),
	.HREADYOUT_S4(HREADY_S4),
	.HRESP_S4(HRESP_S4),
	// Output
	.HSEL_S4(HSEL_S4),
	.HADDR_S4(HADDR_S4),
	.HSIZE_S4(HSIZE_S4),
	.HTRANS_S4(HTRANS_S4),
	.HWRITE_S4(HWRITE_S4),
	.HWDATA_S4(HWDATA_S4),
	.HREADY_S4(HREADYIN_S4),
	.HMASTLOCK_S4(HMASTLOCK_S4),
	.HBURST_S4(HBURST_S4),
	.HPROT_S4(HPROT_S4),

	// Mirrored slave AHB-Lite interface to Slave 5
	// Inputs
	.HRDATA_S5(HRDATA_S5),
	.HREADYOUT_S5(HREADY_S5),
	.HRESP_S5(HRESP_S5),
	// Output
	.HSEL_S5(HSEL_S5),
	.HADDR_S5(HADDR_S5),
	.HSIZE_S5(HSIZE_S5),
	.HTRANS_S5(HTRANS_S5),
	.HWRITE_S5(HWRITE_S5),
	.HWDATA_S5(HWDATA_S5),
	.HREADY_S5(HREADYIN_S5),
	.HMASTLOCK_S5(HMASTLOCK_S5),
	.HBURST_S5(HBURST_S5),
	.HPROT_S5(HPROT_S5),

	// Mirrored slave AHB-Lite interface to Slave 6
	// Inputs
	.HRDATA_S6(HRDATA_S6),
	.HREADYOUT_S6(HREADY_S6),
	.HRESP_S6(HRESP_S6),
	// Output
	.HSEL_S6(HSEL_S6),
	.HADDR_S6(HADDR_S6),
	.HSIZE_S6(HSIZE_S6),
	.HTRANS_S6(HTRANS_S6),
	.HWRITE_S6(HWRITE_S6),
	.HWDATA_S6(HWDATA_S6),
	.HREADY_S6(HREADYIN_S6),
	.HMASTLOCK_S6(HMASTLOCK_S6),
	.HBURST_S6(HBURST_S6),
	.HPROT_S6(HPROT_S6),

	// Mirrored slave AHB-Lite interface to Slave 7
	// Inputs
	.HRDATA_S7(HRDATA_S7),
	.HREADYOUT_S7(HREADY_S7),
	.HRESP_S7(HRESP_S7),
	// Output
	.HSEL_S7(HSEL_S7),
	.HADDR_S7(HADDR_S7),
	.HSIZE_S7(HSIZE_S7),
	.HTRANS_S7(HTRANS_S7),
	.HWRITE_S7(HWRITE_S7),
	.HWDATA_S7(HWDATA_S7),
	.HREADY_S7(HREADYIN_S7),
	.HMASTLOCK_S7(HMASTLOCK_S7),
	.HBURST_S7(HBURST_S7),
	.HPROT_S7(HPROT_S7),

	// Mirrored slave AHB-Lite interface to Slave 8
	// Inputs
	.HRDATA_S8(HRDATA_S8),
	.HREADYOUT_S8(HREADY_S8),
	.HRESP_S8(HRESP_S8),
	// Output
	.HSEL_S8(HSEL_S8),
	.HADDR_S8(HADDR_S8),
	.HSIZE_S8(HSIZE_S8),
	.HTRANS_S8(HTRANS_S8),
	.HWRITE_S8(HWRITE_S8),
	.HWDATA_S8(HWDATA_S8),
	.HREADY_S8(HREADYIN_S8),
	.HMASTLOCK_S8(HMASTLOCK_S8),
	.HBURST_S8(HBURST_S8),
	.HPROT_S8(HPROT_S8),

	// Mirrored slave AHB-Lite interface to Slave 9
	// Inputs
	.HRDATA_S9(HRDATA_S9),
	.HREADYOUT_S9(HREADY_S9),
	.HRESP_S9(HRESP_S9),
	// Output
	.HSEL_S9(HSEL_S9),
	.HADDR_S9(HADDR_S9),
	.HSIZE_S9(HSIZE_S9),
	.HTRANS_S9(HTRANS_S9),
	.HWRITE_S9(HWRITE_S9),
	.HWDATA_S9(HWDATA_S9),
	.HREADY_S9(HREADYIN_S9),
	.HMASTLOCK_S9(HMASTLOCK_S9),
	.HBURST_S9(HBURST_S9),
	.HPROT_S9(HPROT_S9),

	// Mirrored slave AHB-Lite interface to Slave 10
	// Inputs
	.HRDATA_S10(HRDATA_S10),
	.HREADYOUT_S10(HREADY_S10),
	.HRESP_S10(HRESP_S10),
	// Output
	.HSEL_S10(HSEL_S10),
	.HADDR_S10(HADDR_S10),
	.HSIZE_S10(HSIZE_S10),
	.HTRANS_S10(HTRANS_S10),
	.HWRITE_S10(HWRITE_S10),
	.HWDATA_S10(HWDATA_S10),
	.HREADY_S10(HREADYIN_S10),
	.HMASTLOCK_S10(HMASTLOCK_S10),
	.HBURST_S10(HBURST_S10),
	.HPROT_S10(HPROT_S10),

	// Mirrored slave AHB-Lite interface to Slave 11
	// Inputs
	.HRDATA_S11(HRDATA_S11),
	.HREADYOUT_S11(HREADY_S11),
	.HRESP_S11(HRESP_S11),
	// Output
	.HSEL_S11(HSEL_S11),
	.HADDR_S11(HADDR_S11),
	.HSIZE_S11(HSIZE_S11),
	.HTRANS_S11(HTRANS_S11),
	.HWRITE_S11(HWRITE_S11),
	.HWDATA_S11(HWDATA_S11),
	.HREADY_S11(HREADYIN_S11),
	.HMASTLOCK_S11(HMASTLOCK_S11),
	.HBURST_S11(HBURST_S11),
	.HPROT_S11(HPROT_S11),

	// Mirrored slave AHB-Lite interface to Slave 12
	// Inputs
	.HRDATA_S12(HRDATA_S12),
	.HREADYOUT_S12(HREADY_S12),
	.HRESP_S12(HRESP_S12),
	// Output
	.HSEL_S12(HSEL_S12),
	.HADDR_S12(HADDR_S12),
	.HSIZE_S12(HSIZE_S12),
	.HTRANS_S12(HTRANS_S12),
	.HWRITE_S12(HWRITE_S12),
	.HWDATA_S12(HWDATA_S12),
	.HREADY_S12(HREADYIN_S12),
	.HMASTLOCK_S12(HMASTLOCK_S12),
	.HBURST_S12(HBURST_S12),
	.HPROT_S12(HPROT_S12),

	// Mirrored slave AHB-Lite interface to Slave 13
	// Inputs
	.HRDATA_S13(HRDATA_S13),
	.HREADYOUT_S13(HREADY_S13),
	.HRESP_S13(HRESP_S13),
	// Output
	.HSEL_S13(HSEL_S13),
	.HADDR_S13(HADDR_S13),
	.HSIZE_S13(HSIZE_S13),
	.HTRANS_S13(HTRANS_S13),
	.HWRITE_S13(HWRITE_S13),
	.HWDATA_S13(HWDATA_S13),
	.HREADY_S13(HREADYIN_S13),
	.HMASTLOCK_S13(HMASTLOCK_S13),
	.HBURST_S13(HBURST_S13),
	.HPROT_S13(HPROT_S13),

	// Mirrored slave AHB-Lite interface to Slave 14
	// Inputs
	.HRDATA_S14(HRDATA_S14),
	.HREADYOUT_S14(HREADY_S14),
	.HRESP_S14(HRESP_S14),
	// Output
	.HSEL_S14(HSEL_S14),
	.HADDR_S14(HADDR_S14),
	.HSIZE_S14(HSIZE_S14),
	.HTRANS_S14(HTRANS_S14),
	.HWRITE_S14(HWRITE_S14),
	.HWDATA_S14(HWDATA_S14),
	.HREADY_S14(HREADYIN_S14),
	.HMASTLOCK_S14(HMASTLOCK_S14),
	.HBURST_S14(HBURST_S14),
	.HPROT_S14(HPROT_S14),

	// Mirrored slave AHB-Lite interface to Slave 15
	// Inputs
	.HRDATA_S15(HRDATA_S15),
	.HREADYOUT_S15(HREADY_S15),
	.HRESP_S15(HRESP_S15),
	// Output
	.HSEL_S15(HSEL_S15),
	.HADDR_S15(HADDR_S15),
	.HSIZE_S15(HSIZE_S15),
	.HTRANS_S15(HTRANS_S15),
	.HWRITE_S15(HWRITE_S15),
	.HWDATA_S15(HWDATA_S15),
	.HREADY_S15(HREADYIN_S15),
	.HMASTLOCK_S15(HMASTLOCK_S15),
	.HBURST_S15(HBURST_S15),
	.HPROT_S15(HPROT_S15),

	// Mirrored slave AHB-Lite interface to Huge Slave
	// Inputs
	.HRDATA_S16(HRDATA_S16),
	.HREADYOUT_S16(HREADY_S16),
	.HRESP_S16(HRESP_S16),
	// Outputs
	.HSEL_S16(HSEL_S16),
	.HADDR_S16(HADDR_S16),
	.HSIZE_S16(HSIZE_S16),
	.HTRANS_S16(HTRANS_S16),
	.HWRITE_S16(HWRITE_S16),
	.HWDATA_S16(HWDATA_S16),
	.HREADY_S16(HREADYIN_S16),
	.HMASTLOCK_S16(HMASTLOCK_S16),
	.HBURST_S16(HBURST_S16),
	.HPROT_S16(HPROT_S16)
);

// BFM masters monitor various signals
assign GP_IN = {
	REMAP_M0,           // 31
	M1_ACK,             // 30
	M1_REQ,             // 29
	M0_ACK,             // 28
	M0_REQ,             // 27
    FINISHED_master3,   // 26
    FINISHED_master2,   // 25
	FINISHED_master1,   // 24
	FINISHED_master0,   // 23
	6'b0,               // 22:17
    s16_write,          // 16
    s15_write,          // 15
    s14_write,          // 14
    s13_write,          // 13
    s12_write,          // 12
    s11_write,          // 11
    s10_write,          // 10
    s9_write,           //  9
    s8_write,           //  8
    s7_write,           //  7
    s6_write,           //  6
    s5_write,           //  5
    s4_write,           //  4
    s3_write,           //  3
    s2_write,           //  2
    s1_write,           //  1
    s0_write            //  0
};

//-------------------------------------------------------------------------
// Master 0 BFM
//-------------------------------------------------------------------------
BFM_AHBL #(
	.VECTFILE(MASTER0_VECTFILE),
	// passing testbench parameters to BFM ARGVALUE* parameters
	.ARGVALUE0 (FAMILY),
	.ARGVALUE1 (MEMSPACE),
	.ARGVALUE2 (HADDR_SHG_CFG),
	.ARGVALUE3 (SC_0 ),
	.ARGVALUE4 (SC_1 ),
	.ARGVALUE5 (SC_2 ),
	.ARGVALUE6 (SC_3 ),
	.ARGVALUE7 (SC_4 ),
	.ARGVALUE8 (SC_5 ),
	.ARGVALUE9 (SC_6 ),
	.ARGVALUE10(SC_7 ),
	.ARGVALUE11(SC_8 ),
	.ARGVALUE12(SC_9 ),
	.ARGVALUE13(SC_10),
	.ARGVALUE14(SC_11),
	.ARGVALUE15(SC_12),
	.ARGVALUE16(SC_13),
	.ARGVALUE17(SC_14),
	.ARGVALUE18(SC_15),
	.ARGVALUE19(M0_AHBSLOT0ENABLE ),
	.ARGVALUE20(M0_AHBSLOT1ENABLE ),
	.ARGVALUE21(M0_AHBSLOT2ENABLE ),
	.ARGVALUE22(M0_AHBSLOT3ENABLE ),
	.ARGVALUE23(M0_AHBSLOT4ENABLE ),
	.ARGVALUE24(M0_AHBSLOT5ENABLE ),
	.ARGVALUE25(M0_AHBSLOT6ENABLE ),
	.ARGVALUE26(M0_AHBSLOT7ENABLE ),
	.ARGVALUE27(M0_AHBSLOT8ENABLE ),
	.ARGVALUE28(M0_AHBSLOT9ENABLE ),
	.ARGVALUE29(M0_AHBSLOT10ENABLE),
	.ARGVALUE30(M0_AHBSLOT11ENABLE),
	.ARGVALUE31(M0_AHBSLOT12ENABLE),
	.ARGVALUE32(M0_AHBSLOT13ENABLE),
	.ARGVALUE33(M0_AHBSLOT14ENABLE),
	.ARGVALUE34(M0_AHBSLOT15ENABLE),
	.ARGVALUE35(M0_AHBSLOT16ENABLE),
	.ARGVALUE36(M1_AHBSLOT0ENABLE ),
	.ARGVALUE37(M1_AHBSLOT1ENABLE ),
	.ARGVALUE38(M1_AHBSLOT2ENABLE ),
	.ARGVALUE39(M1_AHBSLOT3ENABLE ),
	.ARGVALUE40(M1_AHBSLOT4ENABLE ),
	.ARGVALUE41(M1_AHBSLOT5ENABLE ),
	.ARGVALUE42(M1_AHBSLOT6ENABLE ),
	.ARGVALUE43(M1_AHBSLOT7ENABLE ),
	.ARGVALUE44(M1_AHBSLOT8ENABLE ),
	.ARGVALUE45(M1_AHBSLOT9ENABLE ),
	.ARGVALUE46(M1_AHBSLOT10ENABLE),
	.ARGVALUE47(M1_AHBSLOT11ENABLE),
	.ARGVALUE48(M1_AHBSLOT12ENABLE),
	.ARGVALUE49(M1_AHBSLOT13ENABLE),
	.ARGVALUE50(M1_AHBSLOT14ENABLE),
	.ARGVALUE51(M1_AHBSLOT15ENABLE),
	.ARGVALUE52(M1_AHBSLOT16ENABLE),
	.ARGVALUE53(M2_AHBSLOT0ENABLE ),
	.ARGVALUE54(M2_AHBSLOT1ENABLE ),
	.ARGVALUE55(M2_AHBSLOT2ENABLE ),
	.ARGVALUE56(M2_AHBSLOT3ENABLE ),
	.ARGVALUE57(M2_AHBSLOT4ENABLE ),
	.ARGVALUE58(M2_AHBSLOT5ENABLE ),
	.ARGVALUE59(M2_AHBSLOT6ENABLE ),
	.ARGVALUE60(M2_AHBSLOT7ENABLE ),
	.ARGVALUE61(M2_AHBSLOT8ENABLE ),
	.ARGVALUE62(M2_AHBSLOT9ENABLE ),
	.ARGVALUE63(M2_AHBSLOT10ENABLE),
	.ARGVALUE64(M2_AHBSLOT11ENABLE),
	.ARGVALUE65(M2_AHBSLOT12ENABLE),
	.ARGVALUE66(M2_AHBSLOT13ENABLE),
	.ARGVALUE67(M2_AHBSLOT14ENABLE),
	.ARGVALUE68(M2_AHBSLOT15ENABLE),
	.ARGVALUE69(M2_AHBSLOT16ENABLE),
	.ARGVALUE70(M3_AHBSLOT0ENABLE ),
	.ARGVALUE71(M3_AHBSLOT1ENABLE ),
	.ARGVALUE72(M3_AHBSLOT2ENABLE ),
	.ARGVALUE73(M3_AHBSLOT3ENABLE ),
	.ARGVALUE74(M3_AHBSLOT4ENABLE ),
	.ARGVALUE75(M3_AHBSLOT5ENABLE ),
	.ARGVALUE76(M3_AHBSLOT6ENABLE ),
	.ARGVALUE77(M3_AHBSLOT7ENABLE ),
	.ARGVALUE78(M3_AHBSLOT8ENABLE ),
	.ARGVALUE79(M3_AHBSLOT9ENABLE ),
	.ARGVALUE80(M3_AHBSLOT10ENABLE),
	.ARGVALUE81(M3_AHBSLOT11ENABLE),
	.ARGVALUE82(M3_AHBSLOT12ENABLE),
	.ARGVALUE83(M3_AHBSLOT13ENABLE),
	.ARGVALUE84(M3_AHBSLOT14ENABLE),
	.ARGVALUE85(M3_AHBSLOT15ENABLE),
	.ARGVALUE86(M3_AHBSLOT16ENABLE)
) master0 (
	// Inputs
	.SYSCLK(SYSCLK),
	.SYSRSTN(SYSRSTN),
	.HREADY(HREADY_M0),
	.HRESP(HRESP_M0[0]),
	.HRDATA(HRDATA_M0),
	// Outputs
	.HCLK(HCLK),
	.HRESETN(HRESETN),
	.HTRANS(HTRANS_M0),
	.HBURST(),
	.HSEL(),
	.HPROT(),
	.HSIZE(HSIZE_M0),
	.HWRITE(HWRITE_M0),
	.HMASTLOCK(HMASTLOCK_M0),
	.HADDR(HADDR_M0),
	.HWDATA(HWDATA_M0),
	.INTERRUPT(256'b0),
	.GP_OUT(GP_OUT_M0),
	.GP_IN(GP_IN),
	.EXT_WR(),
	.EXT_RD(),
	.EXT_ADDR(),
	.EXT_DATA(),
	.EXT_WAIT(1'b0),
	.FINISHED(FINISHED_master0),
	.FAILED()
);

// control remap signals from master 0 BFM
assign REMAP_M0			= GP_OUT_M0[31];

// signals for testbench request/acknowledgement between masters
assign M0_REQ			= GP_OUT_M0[27];
assign M0_ACK			= GP_OUT_M0[28];

//-------------------------------------------------------------------------
// Master 1 BFM
//-------------------------------------------------------------------------
BFM_AHBL  #(
	.VECTFILE(MASTER1_VECTFILE),
	// passing testbench parameters to BFM ARGVALUE* parameters
	.ARGVALUE0 (FAMILY),
	.ARGVALUE1 (MEMSPACE),
	.ARGVALUE2 (HADDR_SHG_CFG),
	.ARGVALUE3 (SC_0 ),
	.ARGVALUE4 (SC_1 ),
	.ARGVALUE5 (SC_2 ),
	.ARGVALUE6 (SC_3 ),
	.ARGVALUE7 (SC_4 ),
	.ARGVALUE8 (SC_5 ),
	.ARGVALUE9 (SC_6 ),
	.ARGVALUE10(SC_7 ),
	.ARGVALUE11(SC_8 ),
	.ARGVALUE12(SC_9 ),
	.ARGVALUE13(SC_10),
	.ARGVALUE14(SC_11),
	.ARGVALUE15(SC_12),
	.ARGVALUE16(SC_13),
	.ARGVALUE17(SC_14),
	.ARGVALUE18(SC_15),
	.ARGVALUE19(M0_AHBSLOT0ENABLE ),
	.ARGVALUE20(M0_AHBSLOT1ENABLE ),
	.ARGVALUE21(M0_AHBSLOT2ENABLE ),
	.ARGVALUE22(M0_AHBSLOT3ENABLE ),
	.ARGVALUE23(M0_AHBSLOT4ENABLE ),
	.ARGVALUE24(M0_AHBSLOT5ENABLE ),
	.ARGVALUE25(M0_AHBSLOT6ENABLE ),
	.ARGVALUE26(M0_AHBSLOT7ENABLE ),
	.ARGVALUE27(M0_AHBSLOT8ENABLE ),
	.ARGVALUE28(M0_AHBSLOT9ENABLE ),
	.ARGVALUE29(M0_AHBSLOT10ENABLE),
	.ARGVALUE30(M0_AHBSLOT11ENABLE),
	.ARGVALUE31(M0_AHBSLOT12ENABLE),
	.ARGVALUE32(M0_AHBSLOT13ENABLE),
	.ARGVALUE33(M0_AHBSLOT14ENABLE),
	.ARGVALUE34(M0_AHBSLOT15ENABLE),
	.ARGVALUE35(M0_AHBSLOT16ENABLE),
	.ARGVALUE36(M1_AHBSLOT0ENABLE ),
	.ARGVALUE37(M1_AHBSLOT1ENABLE ),
	.ARGVALUE38(M1_AHBSLOT2ENABLE ),
	.ARGVALUE39(M1_AHBSLOT3ENABLE ),
	.ARGVALUE40(M1_AHBSLOT4ENABLE ),
	.ARGVALUE41(M1_AHBSLOT5ENABLE ),
	.ARGVALUE42(M1_AHBSLOT6ENABLE ),
	.ARGVALUE43(M1_AHBSLOT7ENABLE ),
	.ARGVALUE44(M1_AHBSLOT8ENABLE ),
	.ARGVALUE45(M1_AHBSLOT9ENABLE ),
	.ARGVALUE46(M1_AHBSLOT10ENABLE),
	.ARGVALUE47(M1_AHBSLOT11ENABLE),
	.ARGVALUE48(M1_AHBSLOT12ENABLE),
	.ARGVALUE49(M1_AHBSLOT13ENABLE),
	.ARGVALUE50(M1_AHBSLOT14ENABLE),
	.ARGVALUE51(M1_AHBSLOT15ENABLE),
	.ARGVALUE52(M1_AHBSLOT16ENABLE),
	.ARGVALUE53(M2_AHBSLOT0ENABLE ),
	.ARGVALUE54(M2_AHBSLOT1ENABLE ),
	.ARGVALUE55(M2_AHBSLOT2ENABLE ),
	.ARGVALUE56(M2_AHBSLOT3ENABLE ),
	.ARGVALUE57(M2_AHBSLOT4ENABLE ),
	.ARGVALUE58(M2_AHBSLOT5ENABLE ),
	.ARGVALUE59(M2_AHBSLOT6ENABLE ),
	.ARGVALUE60(M2_AHBSLOT7ENABLE ),
	.ARGVALUE61(M2_AHBSLOT8ENABLE ),
	.ARGVALUE62(M2_AHBSLOT9ENABLE ),
	.ARGVALUE63(M2_AHBSLOT10ENABLE),
	.ARGVALUE64(M2_AHBSLOT11ENABLE),
	.ARGVALUE65(M2_AHBSLOT12ENABLE),
	.ARGVALUE66(M2_AHBSLOT13ENABLE),
	.ARGVALUE67(M2_AHBSLOT14ENABLE),
	.ARGVALUE68(M2_AHBSLOT15ENABLE),
	.ARGVALUE69(M2_AHBSLOT16ENABLE),
	.ARGVALUE70(M3_AHBSLOT0ENABLE ),
	.ARGVALUE71(M3_AHBSLOT1ENABLE ),
	.ARGVALUE72(M3_AHBSLOT2ENABLE ),
	.ARGVALUE73(M3_AHBSLOT3ENABLE ),
	.ARGVALUE74(M3_AHBSLOT4ENABLE ),
	.ARGVALUE75(M3_AHBSLOT5ENABLE ),
	.ARGVALUE76(M3_AHBSLOT6ENABLE ),
	.ARGVALUE77(M3_AHBSLOT7ENABLE ),
	.ARGVALUE78(M3_AHBSLOT8ENABLE ),
	.ARGVALUE79(M3_AHBSLOT9ENABLE ),
	.ARGVALUE80(M3_AHBSLOT10ENABLE),
	.ARGVALUE81(M3_AHBSLOT11ENABLE),
	.ARGVALUE82(M3_AHBSLOT12ENABLE),
	.ARGVALUE83(M3_AHBSLOT13ENABLE),
	.ARGVALUE84(M3_AHBSLOT14ENABLE),
	.ARGVALUE85(M3_AHBSLOT15ENABLE),
	.ARGVALUE86(M3_AHBSLOT16ENABLE)
) master1 (
	// Inputs
	.SYSCLK(SYSCLK),
	.SYSRSTN(SYSRSTN),
	.HREADY(HREADY_M1),
	.HRESP(HRESP_M1[0]),
	.HRDATA(HRDATA_M1),
	// Outputs
	// using master 0 HCLK,HRESETN to drive slaves & DUT
	//.HCLK(HCLK),
	//.HRESETN(HRESETN),
	.HCLK(),
	.HRESETN(),
	.HTRANS(HTRANS_M1),
	.HBURST(),
	.HSEL(),
	.HPROT(),
	.HSIZE(HSIZE_M1),
	.HWRITE(HWRITE_M1),
	.HMASTLOCK(HMASTLOCK_M1),
	.HADDR(HADDR_M1),
	.HWDATA(HWDATA_M1),
	.INTERRUPT(256'b0),
	.GP_OUT(GP_OUT_M1),
	.GP_IN(GP_IN),
	.EXT_WR(),
	.EXT_RD(),
	.EXT_ADDR(),
	.EXT_DATA(),
	.EXT_WAIT(1'b0),
	.FINISHED(FINISHED_master1),
	.FAILED()
);

// signals for testbench request/acknowledgement between masters
assign M1_REQ			= GP_OUT_M1[29];
assign M1_ACK			= GP_OUT_M1[30];

//-------------------------------------------------------------------------
// Master 2 BFM
//-------------------------------------------------------------------------
BFM_AHBL  #(
	.VECTFILE(MASTER2_VECTFILE),
	// passing testbench parameters to BFM ARGVALUE* parameters
	.ARGVALUE0 (FAMILY),
	.ARGVALUE1 (MEMSPACE),
	.ARGVALUE2 (HADDR_SHG_CFG),
	.ARGVALUE3 (SC_0 ),
	.ARGVALUE4 (SC_1 ),
	.ARGVALUE5 (SC_2 ),
	.ARGVALUE6 (SC_3 ),
	.ARGVALUE7 (SC_4 ),
	.ARGVALUE8 (SC_5 ),
	.ARGVALUE9 (SC_6 ),
	.ARGVALUE10(SC_7 ),
	.ARGVALUE11(SC_8 ),
	.ARGVALUE12(SC_9 ),
	.ARGVALUE13(SC_10),
	.ARGVALUE14(SC_11),
	.ARGVALUE15(SC_12),
	.ARGVALUE16(SC_13),
	.ARGVALUE17(SC_14),
	.ARGVALUE18(SC_15),
	.ARGVALUE19(M0_AHBSLOT0ENABLE ),
	.ARGVALUE20(M0_AHBSLOT1ENABLE ),
	.ARGVALUE21(M0_AHBSLOT2ENABLE ),
	.ARGVALUE22(M0_AHBSLOT3ENABLE ),
	.ARGVALUE23(M0_AHBSLOT4ENABLE ),
	.ARGVALUE24(M0_AHBSLOT5ENABLE ),
	.ARGVALUE25(M0_AHBSLOT6ENABLE ),
	.ARGVALUE26(M0_AHBSLOT7ENABLE ),
	.ARGVALUE27(M0_AHBSLOT8ENABLE ),
	.ARGVALUE28(M0_AHBSLOT9ENABLE ),
	.ARGVALUE29(M0_AHBSLOT10ENABLE),
	.ARGVALUE30(M0_AHBSLOT11ENABLE),
	.ARGVALUE31(M0_AHBSLOT12ENABLE),
	.ARGVALUE32(M0_AHBSLOT13ENABLE),
	.ARGVALUE33(M0_AHBSLOT14ENABLE),
	.ARGVALUE34(M0_AHBSLOT15ENABLE),
	.ARGVALUE35(M0_AHBSLOT16ENABLE),
	.ARGVALUE36(M1_AHBSLOT0ENABLE ),
	.ARGVALUE37(M1_AHBSLOT1ENABLE ),
	.ARGVALUE38(M1_AHBSLOT2ENABLE ),
	.ARGVALUE39(M1_AHBSLOT3ENABLE ),
	.ARGVALUE40(M1_AHBSLOT4ENABLE ),
	.ARGVALUE41(M1_AHBSLOT5ENABLE ),
	.ARGVALUE42(M1_AHBSLOT6ENABLE ),
	.ARGVALUE43(M1_AHBSLOT7ENABLE ),
	.ARGVALUE44(M1_AHBSLOT8ENABLE ),
	.ARGVALUE45(M1_AHBSLOT9ENABLE ),
	.ARGVALUE46(M1_AHBSLOT10ENABLE),
	.ARGVALUE47(M1_AHBSLOT11ENABLE),
	.ARGVALUE48(M1_AHBSLOT12ENABLE),
	.ARGVALUE49(M1_AHBSLOT13ENABLE),
	.ARGVALUE50(M1_AHBSLOT14ENABLE),
	.ARGVALUE51(M1_AHBSLOT15ENABLE),
	.ARGVALUE52(M1_AHBSLOT16ENABLE),
	.ARGVALUE53(M2_AHBSLOT0ENABLE ),
	.ARGVALUE54(M2_AHBSLOT1ENABLE ),
	.ARGVALUE55(M2_AHBSLOT2ENABLE ),
	.ARGVALUE56(M2_AHBSLOT3ENABLE ),
	.ARGVALUE57(M2_AHBSLOT4ENABLE ),
	.ARGVALUE58(M2_AHBSLOT5ENABLE ),
	.ARGVALUE59(M2_AHBSLOT6ENABLE ),
	.ARGVALUE60(M2_AHBSLOT7ENABLE ),
	.ARGVALUE61(M2_AHBSLOT8ENABLE ),
	.ARGVALUE62(M2_AHBSLOT9ENABLE ),
	.ARGVALUE63(M2_AHBSLOT10ENABLE),
	.ARGVALUE64(M2_AHBSLOT11ENABLE),
	.ARGVALUE65(M2_AHBSLOT12ENABLE),
	.ARGVALUE66(M2_AHBSLOT13ENABLE),
	.ARGVALUE67(M2_AHBSLOT14ENABLE),
	.ARGVALUE68(M2_AHBSLOT15ENABLE),
	.ARGVALUE69(M2_AHBSLOT16ENABLE),
	.ARGVALUE70(M3_AHBSLOT0ENABLE ),
	.ARGVALUE71(M3_AHBSLOT1ENABLE ),
	.ARGVALUE72(M3_AHBSLOT2ENABLE ),
	.ARGVALUE73(M3_AHBSLOT3ENABLE ),
	.ARGVALUE74(M3_AHBSLOT4ENABLE ),
	.ARGVALUE75(M3_AHBSLOT5ENABLE ),
	.ARGVALUE76(M3_AHBSLOT6ENABLE ),
	.ARGVALUE77(M3_AHBSLOT7ENABLE ),
	.ARGVALUE78(M3_AHBSLOT8ENABLE ),
	.ARGVALUE79(M3_AHBSLOT9ENABLE ),
	.ARGVALUE80(M3_AHBSLOT10ENABLE),
	.ARGVALUE81(M3_AHBSLOT11ENABLE),
	.ARGVALUE82(M3_AHBSLOT12ENABLE),
	.ARGVALUE83(M3_AHBSLOT13ENABLE),
	.ARGVALUE84(M3_AHBSLOT14ENABLE),
	.ARGVALUE85(M3_AHBSLOT15ENABLE),
	.ARGVALUE86(M3_AHBSLOT16ENABLE)
) master2 (
	// Inputs
	.SYSCLK(SYSCLK),
	.SYSRSTN(SYSRSTN),
	.HREADY(HREADY_M2),
	.HRESP(HRESP_M2[0]),
	.HRDATA(HRDATA_M2),
	// Outputs
	// using master 0 HCLK,HRESETN to drive slaves & DUT
	//.HCLK(HCLK),
	//.HRESETN(HRESETN),
	.HCLK(),
	.HRESETN(),
	.HTRANS(HTRANS_M2),
	.HBURST(),
	.HSEL(),
	.HPROT(),
	.HSIZE(HSIZE_M2),
	.HWRITE(HWRITE_M2),
	.HMASTLOCK(HMASTLOCK_M2),
	.HADDR(HADDR_M2),
	.HWDATA(HWDATA_M2),
	.INTERRUPT(256'b0),
	.GP_OUT(),
	.GP_IN(32'b0),
	.EXT_WR(),
	.EXT_RD(),
	.EXT_ADDR(),
	.EXT_DATA(),
	.EXT_WAIT(1'b0),
	.FINISHED(FINISHED_master2),
	.FAILED()
);

//-------------------------------------------------------------------------
// Master 3 BFM
//-------------------------------------------------------------------------
BFM_AHBL  #(
	.VECTFILE(MASTER3_VECTFILE),
	// passing testbench parameters to BFM ARGVALUE* parameters
	.ARGVALUE0 (FAMILY),
	.ARGVALUE1 (MEMSPACE),
	.ARGVALUE2 (HADDR_SHG_CFG),
	.ARGVALUE3 (SC_0 ),
	.ARGVALUE4 (SC_1 ),
	.ARGVALUE5 (SC_2 ),
	.ARGVALUE6 (SC_3 ),
	.ARGVALUE7 (SC_4 ),
	.ARGVALUE8 (SC_5 ),
	.ARGVALUE9 (SC_6 ),
	.ARGVALUE10(SC_7 ),
	.ARGVALUE11(SC_8 ),
	.ARGVALUE12(SC_9 ),
	.ARGVALUE13(SC_10),
	.ARGVALUE14(SC_11),
	.ARGVALUE15(SC_12),
	.ARGVALUE16(SC_13),
	.ARGVALUE17(SC_14),
	.ARGVALUE18(SC_15),
	.ARGVALUE19(M0_AHBSLOT0ENABLE ),
	.ARGVALUE20(M0_AHBSLOT1ENABLE ),
	.ARGVALUE21(M0_AHBSLOT2ENABLE ),
	.ARGVALUE22(M0_AHBSLOT3ENABLE ),
	.ARGVALUE23(M0_AHBSLOT4ENABLE ),
	.ARGVALUE24(M0_AHBSLOT5ENABLE ),
	.ARGVALUE25(M0_AHBSLOT6ENABLE ),
	.ARGVALUE26(M0_AHBSLOT7ENABLE ),
	.ARGVALUE27(M0_AHBSLOT8ENABLE ),
	.ARGVALUE28(M0_AHBSLOT9ENABLE ),
	.ARGVALUE29(M0_AHBSLOT10ENABLE),
	.ARGVALUE30(M0_AHBSLOT11ENABLE),
	.ARGVALUE31(M0_AHBSLOT12ENABLE),
	.ARGVALUE32(M0_AHBSLOT13ENABLE),
	.ARGVALUE33(M0_AHBSLOT14ENABLE),
	.ARGVALUE34(M0_AHBSLOT15ENABLE),
	.ARGVALUE35(M0_AHBSLOT16ENABLE),
	.ARGVALUE36(M1_AHBSLOT0ENABLE ),
	.ARGVALUE37(M1_AHBSLOT1ENABLE ),
	.ARGVALUE38(M1_AHBSLOT2ENABLE ),
	.ARGVALUE39(M1_AHBSLOT3ENABLE ),
	.ARGVALUE40(M1_AHBSLOT4ENABLE ),
	.ARGVALUE41(M1_AHBSLOT5ENABLE ),
	.ARGVALUE42(M1_AHBSLOT6ENABLE ),
	.ARGVALUE43(M1_AHBSLOT7ENABLE ),
	.ARGVALUE44(M1_AHBSLOT8ENABLE ),
	.ARGVALUE45(M1_AHBSLOT9ENABLE ),
	.ARGVALUE46(M1_AHBSLOT10ENABLE),
	.ARGVALUE47(M1_AHBSLOT11ENABLE),
	.ARGVALUE48(M1_AHBSLOT12ENABLE),
	.ARGVALUE49(M1_AHBSLOT13ENABLE),
	.ARGVALUE50(M1_AHBSLOT14ENABLE),
	.ARGVALUE51(M1_AHBSLOT15ENABLE),
	.ARGVALUE52(M1_AHBSLOT16ENABLE),
	.ARGVALUE53(M2_AHBSLOT0ENABLE ),
	.ARGVALUE54(M2_AHBSLOT1ENABLE ),
	.ARGVALUE55(M2_AHBSLOT2ENABLE ),
	.ARGVALUE56(M2_AHBSLOT3ENABLE ),
	.ARGVALUE57(M2_AHBSLOT4ENABLE ),
	.ARGVALUE58(M2_AHBSLOT5ENABLE ),
	.ARGVALUE59(M2_AHBSLOT6ENABLE ),
	.ARGVALUE60(M2_AHBSLOT7ENABLE ),
	.ARGVALUE61(M2_AHBSLOT8ENABLE ),
	.ARGVALUE62(M2_AHBSLOT9ENABLE ),
	.ARGVALUE63(M2_AHBSLOT10ENABLE),
	.ARGVALUE64(M2_AHBSLOT11ENABLE),
	.ARGVALUE65(M2_AHBSLOT12ENABLE),
	.ARGVALUE66(M2_AHBSLOT13ENABLE),
	.ARGVALUE67(M2_AHBSLOT14ENABLE),
	.ARGVALUE68(M2_AHBSLOT15ENABLE),
	.ARGVALUE69(M2_AHBSLOT16ENABLE),
	.ARGVALUE70(M3_AHBSLOT0ENABLE ),
	.ARGVALUE71(M3_AHBSLOT1ENABLE ),
	.ARGVALUE72(M3_AHBSLOT2ENABLE ),
	.ARGVALUE73(M3_AHBSLOT3ENABLE ),
	.ARGVALUE74(M3_AHBSLOT4ENABLE ),
	.ARGVALUE75(M3_AHBSLOT5ENABLE ),
	.ARGVALUE76(M3_AHBSLOT6ENABLE ),
	.ARGVALUE77(M3_AHBSLOT7ENABLE ),
	.ARGVALUE78(M3_AHBSLOT8ENABLE ),
	.ARGVALUE79(M3_AHBSLOT9ENABLE ),
	.ARGVALUE80(M3_AHBSLOT10ENABLE),
	.ARGVALUE81(M3_AHBSLOT11ENABLE),
	.ARGVALUE82(M3_AHBSLOT12ENABLE),
	.ARGVALUE83(M3_AHBSLOT13ENABLE),
	.ARGVALUE84(M3_AHBSLOT14ENABLE),
	.ARGVALUE85(M3_AHBSLOT15ENABLE),
	.ARGVALUE86(M3_AHBSLOT16ENABLE)
) master3 (
	// Inputs
	.SYSCLK(SYSCLK),
	.SYSRSTN(SYSRSTN),
	.HREADY(HREADY_M3),
	.HRESP(HRESP_M3[0]),
	.HRDATA(HRDATA_M3),
	// Outputs
	// using master 0 HCLK,HRESETN to drive slaves & DUT
	//.HCLK(HCLK),
	//.HRESETN(HRESETN),
	.HCLK(),
	.HRESETN(),
	.HTRANS(HTRANS_M3),
	.HBURST(),
	.HSEL(),
	.HPROT(),
	.HSIZE(HSIZE_M3),
	.HWRITE(HWRITE_M3),
	.HMASTLOCK(HMASTLOCK_M3),
	.HADDR(HADDR_M3),
	.HWDATA(HWDATA_M3),
	.INTERRUPT(256'b0),
	.GP_OUT(),
	.GP_IN(32'b0),
	.EXT_WR(),
	.EXT_RD(),
	.EXT_ADDR(),
	.EXT_DATA(),
	.EXT_WAIT(1'b0),
	.FINISHED(FINISHED_master3),
	.FAILED()
);


    BFM_AHBSLAVE #(.AWIDTH   (16),
                   .DEPTH    (65536),
                   .INITFILE (" "),
                   .ID       (1),
                   .ENFUNC   (0),
                   .TPD      (5),
                   .DEBUG    (0) )
    slave0 (
	// MP7Bridge interface
	// Inputs
	.HCLK(HCLK),
	.HRESETN(HRESETN),
	// AhbFabric interface
	// Inputs
	.HWRITE(HWRITE_S0),
	.HSIZE(HSIZE_S0),
	.HTRANS(HTRANS_S0),
	.HWDATA(HWDATA_S0),
	.HREADYIN(HREADYIN_S0),
	.HSEL(HSEL_S0),
	.HADDR(HADDR_S0[15:0]),
	.HMASTLOCK(1'b0),
	.HBURST(HBURST_S0),
	.HPROT(HPROT_S0),
	// Output
	.HRDATA(HRDATA_S0),
	.HRESP(HRESP_S0[0]),
	.HREADYOUT(HREADY_S0)
    );

    BFM_AHBSLAVE #(.AWIDTH   (16),
                   .DEPTH    (65536),
                   .INITFILE (" "),
                   .ID       (1),
                   .ENFUNC   (0),
                   .TPD      (5),
                   .DEBUG    (0) )
    slave1 (
	// MP7Bridge interface
	// Inputs
	.HCLK(HCLK),
	.HRESETN(HRESETN),
	// AhbFabric interface
	// Inputs
	.HWRITE(HWRITE_S1),
	.HSIZE(HSIZE_S1),
	.HTRANS(HTRANS_S1),
	.HWDATA(HWDATA_S1),
	.HREADYIN(HREADYIN_S1),
	.HSEL(HSEL_S1),
	.HADDR(HADDR_S1[15:0]),
	.HMASTLOCK(1'b0),
	.HBURST(HBURST_S1),
	.HPROT(HPROT_S1),
	// Output
	.HRDATA(HRDATA_S1),
	.HRESP(HRESP_S1[0]),
	.HREADYOUT(HREADY_S1)
    );

    BFM_AHBSLAVE #(.AWIDTH   (16),
                   .DEPTH    (65536),
                   .INITFILE (" "),
                   .ID       (1),
                   .ENFUNC   (0),
                   .TPD      (5),
                   .DEBUG    (0) )
    slave2 (
	// MP7Bridge interface
	// Inputs
	.HCLK(HCLK),
	.HRESETN(HRESETN),
	// AhbFabric interface
	// Inputs
	.HWRITE(HWRITE_S2),
	.HSIZE(HSIZE_S2),
	.HTRANS(HTRANS_S2),
	.HWDATA(HWDATA_S2),
	.HREADYIN(HREADYIN_S2),
	.HSEL(HSEL_S2),
	.HADDR(HADDR_S2[15:0]),
	.HMASTLOCK(1'b0),
	.HBURST(HBURST_S2),
	.HPROT(HPROT_S2),
	// Output
	.HRDATA(HRDATA_S2),
	.HRESP(HRESP_S2[0]),
	.HREADYOUT(HREADY_S2)
    );


    BFM_AHBSLAVE #(.AWIDTH   (16),
                   .DEPTH    (65536),
                   .INITFILE (" "),
                   .ID       (1),
                   .ENFUNC   (0),
                   .TPD      (5),
                   .DEBUG    (0) )
    slave3 (
	// MP7Bridge interface
	// Inputs
	.HCLK(HCLK),
	.HRESETN(HRESETN),
	// AhbFabric interface
	// Inputs
	.HWRITE(HWRITE_S3),
	.HSIZE(HSIZE_S3),
	.HTRANS(HTRANS_S3),
	.HWDATA(HWDATA_S3),
	.HREADYIN(HREADYIN_S3),
	.HSEL(HSEL_S3),
	.HADDR(HADDR_S3[15:0]),
	.HMASTLOCK(1'b0),
	.HBURST(HBURST_S3),
	.HPROT(HPROT_S3),
	// Output
	.HRDATA(HRDATA_S3),
	.HRESP(HRESP_S3[0]),
	.HREADYOUT(HREADY_S3)
    );


    BFM_AHBSLAVE #(.AWIDTH   (16),
                   .DEPTH    (65536),
                   .INITFILE (" "),
                   .ID       (1),
                   .ENFUNC   (0),
                   .TPD      (5),
                   .DEBUG    (0) )
    slave4 (
	// MP7Bridge interface
	// Inputs
	.HCLK(HCLK),
	.HRESETN(HRESETN),
	// AhbFabric interface
	// Inputs
	.HWRITE(HWRITE_S4),
	.HSIZE(HSIZE_S4),
	.HTRANS(HTRANS_S4),
	.HWDATA(HWDATA_S4),
	.HREADYIN(HREADYIN_S4),
	.HSEL(HSEL_S4),
	.HADDR(HADDR_S4[15:0]),
	.HMASTLOCK(1'b0),
	.HBURST(HBURST_S4),
	.HPROT(HPROT_S4),
	// Output
	.HRDATA(HRDATA_S4),
	.HRESP(HRESP_S4[0]),
	.HREADYOUT(HREADY_S4)
    );

    BFM_AHBSLAVE #(.AWIDTH   (16),
                   .DEPTH    (65536),
                   .INITFILE (" "),
                   .ID       (1),
                   .ENFUNC   (0),
                   .TPD      (5),
                   .DEBUG    (0) )
    slave5 (
	// MP7Bridge interface
	// Inputs
	.HCLK(HCLK),
	.HRESETN(HRESETN),
	// AhbFabric interface
	// Inputs
	.HWRITE(HWRITE_S5),
	.HSIZE(HSIZE_S5),
	.HTRANS(HTRANS_S5),
	.HWDATA(HWDATA_S5),
	.HREADYIN(HREADYIN_S5),
	.HSEL(HSEL_S5),
	.HADDR(HADDR_S5[15:0]),
	.HMASTLOCK(1'b0),
	.HBURST(HBURST_S5),
	.HPROT(HPROT_S5),
	// Output
	.HRDATA(HRDATA_S5),
	.HRESP(HRESP_S5[0]),
	.HREADYOUT(HREADY_S5)
    );

    BFM_AHBSLAVE #(.AWIDTH   (16),
                   .DEPTH    (65536),
                   .INITFILE (" "),
                   .ID       (1),
                   .ENFUNC   (0),
                   .TPD      (5),
                   .DEBUG    (0) )
    slave6 (
	// MP7Bridge interface
	// Inputs
	.HCLK(HCLK),
	.HRESETN(HRESETN),
	// AhbFabric interface
	// Inputs
	.HWRITE(HWRITE_S6),
	.HSIZE(HSIZE_S6),
	.HTRANS(HTRANS_S6),
	.HWDATA(HWDATA_S6),
	.HREADYIN(HREADYIN_S6),
	.HSEL(HSEL_S6),
	.HADDR(HADDR_S6[15:0]),
	.HMASTLOCK(1'b0),
	.HBURST(HBURST_S6),
	.HPROT(HPROT_S6),
	// Output
	.HRDATA(HRDATA_S6),
	.HRESP(HRESP_S6[0]),
	.HREADYOUT(HREADY_S6)
    );

    BFM_AHBSLAVE #(.AWIDTH   (16),
                   .DEPTH    (65536),
                   .INITFILE (" "),
                   .ID       (1),
                   .ENFUNC   (0),
                   .TPD      (5),
                   .DEBUG    (0) )
    slave7 (
	// MP7Bridge interface
	// Inputs
	.HCLK(HCLK),
	.HRESETN(HRESETN),
	// AhbFabric interface
	// Inputs
	.HWRITE(HWRITE_S7),
	.HSIZE(HSIZE_S7),
	.HTRANS(HTRANS_S7),
	.HWDATA(HWDATA_S7),
	.HREADYIN(HREADYIN_S7),
	.HSEL(HSEL_S7),
	.HADDR(HADDR_S7[15:0]),
	.HMASTLOCK(1'b0),
	.HBURST(HBURST_S7),
	.HPROT(HPROT_S7),
	// Output
	.HRDATA(HRDATA_S7),
	.HRESP(HRESP_S7[0]),
	.HREADYOUT(HREADY_S7)
    );


    BFM_AHBSLAVE #(.AWIDTH   (16),
                   .DEPTH    (65536),
                   .INITFILE (" "),
                   .ID       (1),
                   .ENFUNC   (0),
                   .TPD      (5),
                   .DEBUG    (0) )
    slave8 (
	// MP7Bridge interface
	// Inputs
	.HCLK(HCLK),
	.HRESETN(HRESETN),
	// AhbFabric interface
	// Inputs
	.HWRITE(HWRITE_S8),
	.HSIZE(HSIZE_S8),
	.HTRANS(HTRANS_S8),
	.HWDATA(HWDATA_S8),
	.HREADYIN(HREADYIN_S8),
	.HSEL(HSEL_S8),
	.HADDR(HADDR_S8[15:0]),
	.HMASTLOCK(1'b0),
	.HBURST(HBURST_S8),
	.HPROT(HPROT_S8),
	// Output
	.HRDATA(HRDATA_S8),
	.HRESP(HRESP_S8[0]),
	.HREADYOUT(HREADY_S8)
    );

    BFM_AHBSLAVE #(.AWIDTH   (16),
                   .DEPTH    (65536),
                   .INITFILE (" "),
                   .ID       (1),
                   .ENFUNC   (0),
                   .TPD      (5),
                   .DEBUG    (0) )
    slave9 (
	// MP7Bridge interface
	// Inputs
	.HCLK(HCLK),
	.HRESETN(HRESETN),
	// AhbFabric interface
	// Inputs
	.HWRITE(HWRITE_S9),
	.HSIZE(HSIZE_S9),
	.HTRANS(HTRANS_S9),
	.HWDATA(HWDATA_S9),
	.HREADYIN(HREADYIN_S9),
	.HSEL(HSEL_S9),
	.HADDR(HADDR_S9[15:0]),
	.HMASTLOCK(1'b0),
	.HBURST(HBURST_S9),
	.HPROT(HPROT_S9),
	// Output
	.HRDATA(HRDATA_S9),
	.HRESP(HRESP_S9[0]),
	.HREADYOUT(HREADY_S9)
    );

    BFM_AHBSLAVE #(.AWIDTH   (16),
                   .DEPTH    (65536),
                   .INITFILE (" "),
                   .ID       (1),
                   .ENFUNC   (0),
                   .TPD      (5),
                   .DEBUG    (0) )
    slave10 (
	// MP7Bridge interface
	// Inputs
	.HCLK(HCLK),
	.HRESETN(HRESETN),
	// AhbFabric interface
	// Inputs
	.HWRITE(HWRITE_S10),
	.HSIZE(HSIZE_S10),
	.HTRANS(HTRANS_S10),
	.HWDATA(HWDATA_S10),
	.HREADYIN(HREADYIN_S10),
	.HSEL(HSEL_S10),
	.HADDR(HADDR_S10[15:0]),
	.HMASTLOCK(1'b0),
	.HBURST(HBURST_S10),
	.HPROT(HPROT_S10),
	// Output
	.HRDATA(HRDATA_S10),
	.HRESP(HRESP_S10[0]),
	.HREADYOUT(HREADY_S10)
    );

    BFM_AHBSLAVE #(.AWIDTH   (16),
                   .DEPTH    (65536),
                   .INITFILE (" "),
                   .ID       (1),
                   .ENFUNC   (0),
                   .TPD      (5),
                   .DEBUG    (0) )
    slave11 (
	// MP7Bridge interface
	// Inputs
	.HCLK(HCLK),
	.HRESETN(HRESETN),
	// AhbFabric interface
	// Inputs
	.HWRITE(HWRITE_S11),
	.HSIZE(HSIZE_S11),
	.HTRANS(HTRANS_S11),
	.HWDATA(HWDATA_S11),
	.HREADYIN(HREADYIN_S11),
	.HSEL(HSEL_S11),
	.HADDR(HADDR_S11[15:0]),
	.HMASTLOCK(1'b0),
	.HBURST(HBURST_S11),
	.HPROT(HPROT_S11),
	// Output
	.HRDATA(HRDATA_S11),
	.HRESP(HRESP_S11[0]),
	.HREADYOUT(HREADY_S11)
    );

    BFM_AHBSLAVE #(.AWIDTH   (16),
                   .DEPTH    (65536),
                   .INITFILE (" "),
                   .ID       (1),
                   .ENFUNC   (0),
                   .TPD      (5),
                   .DEBUG    (0) )
    slave12 (
	// MP7Bridge interface
	// Inputs
	.HCLK(HCLK),
	.HRESETN(HRESETN),
	// AhbFabric interface
	// Inputs
	.HWRITE(HWRITE_S12),
	.HSIZE(HSIZE_S12),
	.HTRANS(HTRANS_S12),
	.HWDATA(HWDATA_S12),
	.HREADYIN(HREADYIN_S12),
	.HSEL(HSEL_S12),
	.HADDR(HADDR_S12[15:0]),
	.HMASTLOCK(1'b0),
	.HBURST(HBURST_S12),
	.HPROT(HPROT_S12),
	// Output
	.HRDATA(HRDATA_S12),
	.HRESP(HRESP_S12[0]),
	.HREADYOUT(HREADY_S12)
    );

    BFM_AHBSLAVE #(.AWIDTH   (16),
                   .DEPTH    (65536),
                   .INITFILE (" "),
                   .ID       (1),
                   .ENFUNC   (0),
                   .TPD      (5),
                   .DEBUG    (0) )
    slave13 (
	// MP7Bridge interface
	// Inputs
	.HCLK(HCLK),
	.HRESETN(HRESETN),
	// AhbFabric interface
	// Inputs
	.HWRITE(HWRITE_S13),
	.HSIZE(HSIZE_S13),
	.HTRANS(HTRANS_S13),
	.HWDATA(HWDATA_S13),
	.HREADYIN(HREADYIN_S13),
	.HSEL(HSEL_S13),
	.HADDR(HADDR_S13[15:0]),
	.HMASTLOCK(1'b0),
	.HBURST(HBURST_S13),
	.HPROT(HPROT_S13),
	// Output
	.HRDATA(HRDATA_S13),
	.HRESP(HRESP_S13[0]),
	.HREADYOUT(HREADY_S13)
    );


    BFM_AHBSLAVE #(.AWIDTH   (16),
                   .DEPTH    (65536),
                   .INITFILE (" "),
                   .ID       (1),
                   .ENFUNC   (0),
                   .TPD      (5),
                   .DEBUG    (0) )
    slave14 (
	// MP7Bridge interface
	// Inputs
	.HCLK(HCLK),
	.HRESETN(HRESETN),
	// AhbFabric interface
	// Inputs
	.HWRITE(HWRITE_S14),
	.HSIZE(HSIZE_S14),
	.HTRANS(HTRANS_S14),
	.HWDATA(HWDATA_S14),
	.HREADYIN(HREADYIN_S14),
	.HSEL(HSEL_S14),
	.HADDR(HADDR_S14[15:0]),
	.HMASTLOCK(1'b0),
	.HBURST(HBURST_S14),
	.HPROT(HPROT_S14),
	// Output
	.HRDATA(HRDATA_S14),
	.HRESP(HRESP_S14[0]),
	.HREADYOUT(HREADY_S14)
    );

    BFM_AHBSLAVE #(.AWIDTH   (16),
                   .DEPTH    (65536),
                   .INITFILE (" "),
                   .ID       (1),
                   .ENFUNC   (0),
                   .TPD      (5),
                   .DEBUG    (0) )
    slave15 (
	// MP7Bridge interface
	// Inputs
	.HCLK(HCLK),
	.HRESETN(HRESETN),
	// AhbFabric interface
	// Inputs
	.HWRITE(HWRITE_S15),
	.HSIZE(HSIZE_S15),
	.HTRANS(HTRANS_S15),
	.HWDATA(HWDATA_S15),
	.HREADYIN(HREADYIN_S15),
	.HSEL(HSEL_S15),
	.HADDR(HADDR_S15[15:0]),
	.HMASTLOCK(1'b0),
	.HBURST(HBURST_S15),
	.HPROT(HPROT_S15),
	// Output
	.HRDATA(HRDATA_S15),
	.HRESP(HRESP_S15[0]),
	.HREADYOUT(HREADY_S15)
    );

// may need to make this bigger for 'huge' slave
    BFM_AHBSLAVE #(.AWIDTH   (16),
                   .DEPTH    (65536),
                   .INITFILE (" "),
                   .ID       (1),
                   .ENFUNC   (0),
                   .TPD      (5),
                   .DEBUG    (0) )
    slave16 (
	// MP7Bridge interface
	// Inputs
	.HCLK(HCLK),
	.HRESETN(HRESETN),
	// AhbFabric interface
	// Inputs
	.HWRITE(HWRITE_S16),
	.HSIZE(HSIZE_S16),
	.HTRANS(HTRANS_S16),
	.HWDATA(HWDATA_S16),
	.HREADYIN(HREADYIN_S16),
	.HSEL(HSEL_S16),
	.HADDR(HADDR_S16[15:0]),
	.HMASTLOCK(1'b0),
	.HBURST(HBURST_S16),
	.HPROT(HPROT_S16),
	// Output
	.HRDATA(HRDATA_S16),
	.HRESP(HRESP_S16[0]),
	.HREADYOUT(HREADY_S16)
    );

    //---------------------------------------------------------------------
    // Detect writes to individual slots
    //---------------------------------------------------------------------
    always @(posedge HCLK or negedge HRESETN)
    begin
        if (!HRESETN)
        begin
            s0_write <= 1'b0;
            s1_write <= 1'b0;
            s2_write <= 1'b0;
            s3_write <= 1'b0;
            s4_write <= 1'b0;
            s5_write <= 1'b0;
            s6_write <= 1'b0;
            s7_write <= 1'b0;
            s8_write <= 1'b0;
            s9_write <= 1'b0;
            s10_write <= 1'b0;
            s11_write <= 1'b0;
            s12_write <= 1'b0;
            s13_write <= 1'b0;
            s14_write <= 1'b0;
            s15_write <= 1'b0;
            s16_write <= 1'b0;
        end
        else
        begin
            // Set write indication bits
            if (HSEL_S0 && HTRANS_S0[1] && HWRITE_S0) s0_write <= 1'b1;
            if (HSEL_S1 && HTRANS_S1[1] && HWRITE_S1) s1_write <= 1'b1;
            if (HSEL_S2 && HTRANS_S2[1] && HWRITE_S2) s2_write <= 1'b1;
            if (HSEL_S3 && HTRANS_S3[1] && HWRITE_S3) s3_write <= 1'b1;
            if (HSEL_S4 && HTRANS_S4[1] && HWRITE_S4) s4_write <= 1'b1;
            if (HSEL_S5 && HTRANS_S5[1] && HWRITE_S5) s5_write <= 1'b1;
            if (HSEL_S6 && HTRANS_S6[1] && HWRITE_S6) s6_write <= 1'b1;
            if (HSEL_S7 && HTRANS_S7[1] && HWRITE_S7) s7_write <= 1'b1;
            if (HSEL_S8 && HTRANS_S8[1] && HWRITE_S8) s8_write <= 1'b1;
            if (HSEL_S9 && HTRANS_S9[1] && HWRITE_S9) s9_write <= 1'b1;
            if (HSEL_S10 && HTRANS_S10[1] && HWRITE_S10) s10_write <= 1'b1;
            if (HSEL_S11 && HTRANS_S11[1] && HWRITE_S11) s11_write <= 1'b1;
            if (HSEL_S12 && HTRANS_S12[1] && HWRITE_S12) s12_write <= 1'b1;
            if (HSEL_S13 && HTRANS_S13[1] && HWRITE_S13) s13_write <= 1'b1;
            if (HSEL_S14 && HTRANS_S14[1] && HWRITE_S14) s14_write <= 1'b1;
            if (HSEL_S15 && HTRANS_S15[1] && HWRITE_S15) s15_write <= 1'b1;
            if (HSEL_S16 && HTRANS_S16[1] && HWRITE_S16) s16_write <= 1'b1;
            // Clear write indication bits
            if (GP_OUT_M0[0]) s0_write <= 1'b0;
            if (GP_OUT_M0[1]) s1_write <= 1'b0;
            if (GP_OUT_M0[2]) s2_write <= 1'b0;
            if (GP_OUT_M0[3]) s3_write <= 1'b0;
            if (GP_OUT_M0[4]) s4_write <= 1'b0;
            if (GP_OUT_M0[5]) s5_write <= 1'b0;
            if (GP_OUT_M0[6]) s6_write <= 1'b0;
            if (GP_OUT_M0[7]) s7_write <= 1'b0;
            if (GP_OUT_M0[8]) s8_write <= 1'b0;
            if (GP_OUT_M0[9]) s9_write <= 1'b0;
            if (GP_OUT_M0[10]) s10_write <= 1'b0;
            if (GP_OUT_M0[11]) s11_write <= 1'b0;
            if (GP_OUT_M0[12]) s12_write <= 1'b0;
            if (GP_OUT_M0[13]) s13_write <= 1'b0;
            if (GP_OUT_M0[14]) s14_write <= 1'b0;
            if (GP_OUT_M0[15]) s15_write <= 1'b0;
            if (GP_OUT_M0[16]) s16_write <= 1'b0;
        end
    end

endmodule
